/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityimpl;

import com.codahale.metrics.Timer;
import io.engineblock.activityapi.core.ActionDispenser;
import io.engineblock.activityapi.core.Activity;
import io.engineblock.activityapi.core.ActivityController;
import io.engineblock.activityapi.core.ActivityInstrumentation;
import io.engineblock.activityapi.core.CoreActivityInstrumentation;
import io.engineblock.activityapi.core.MotorDispenser;
import io.engineblock.activityapi.core.RunState;
import io.engineblock.activityapi.cyclelog.filters.IntPredicateDispenser;
import io.engineblock.activityapi.input.InputDispenser;
import io.engineblock.activityapi.output.OutputDispenser;
import io.engineblock.activityapi.planning.OpSequence;
import io.engineblock.activityapi.ratelimits.RateLimiter;
import io.engineblock.activityapi.ratelimits.RateLimiters;
import io.engineblock.activityapi.ratelimits.RateSpec;
import io.engineblock.activityimpl.ActivityDef;
import io.engineblock.metrics.ActivityMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleActivity
implements Activity {
    private static final Logger logger = LoggerFactory.getLogger(SimpleActivity.class);
    protected ActivityDef activityDef;
    private List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private MotorDispenser motorDispenser;
    private InputDispenser inputDispenser;
    private ActionDispenser actionDispenser;
    private OutputDispenser markerDispenser;
    private IntPredicateDispenser resultFilterDispenser;
    private RunState runState = RunState.Uninitialized;
    private RateLimiter strideLimiter;
    private RateLimiter cycleLimiter;
    private RateLimiter phaseLimiter;
    private ActivityController activityController;
    private ActivityInstrumentation activityInstrumentation;

    public SimpleActivity(ActivityDef activityDef) {
        this.activityDef = activityDef;
    }

    public SimpleActivity(String activityDefString) {
        this(ActivityDef.parseActivityDef(activityDefString));
    }

    @Override
    public void initActivity() {
        this.onActivityDefUpdate(this.activityDef);
    }

    @Override
    public synchronized RunState getRunState() {
        return this.runState;
    }

    @Override
    public synchronized void setRunState(RunState runState) {
        this.runState = runState;
    }

    @Override
    public final MotorDispenser getMotorDispenserDelegate() {
        return this.motorDispenser;
    }

    @Override
    public final void setMotorDispenserDelegate(MotorDispenser motorDispenser) {
        this.motorDispenser = motorDispenser;
    }

    @Override
    public final InputDispenser getInputDispenserDelegate() {
        return this.inputDispenser;
    }

    @Override
    public final void setInputDispenserDelegate(InputDispenser inputDispenser) {
        this.inputDispenser = inputDispenser;
    }

    @Override
    public final ActionDispenser getActionDispenserDelegate() {
        return this.actionDispenser;
    }

    @Override
    public final void setActionDispenserDelegate(ActionDispenser actionDispenser) {
        this.actionDispenser = actionDispenser;
    }

    @Override
    public IntPredicateDispenser getResultFilterDispenserDelegate() {
        return this.resultFilterDispenser;
    }

    @Override
    public void setResultFilterDispenserDelegate(IntPredicateDispenser resultFilterDispenser) {
        this.resultFilterDispenser = resultFilterDispenser;
    }

    @Override
    public OutputDispenser getMarkerDispenserDelegate() {
        return this.markerDispenser;
    }

    @Override
    public void setOutputDispenserDelegate(OutputDispenser outputDispenser) {
        this.markerDispenser = outputDispenser;
    }

    @Override
    public ActivityDef getActivityDef() {
        return this.activityDef;
    }

    public String toString() {
        return this.getAlias();
    }

    @Override
    public int compareTo(Activity o) {
        return this.getAlias().compareTo(o.getAlias());
    }

    @Override
    public ActivityController getActivityController() {
        return this.activityController;
    }

    @Override
    public void setActivityController(ActivityController activityController) {
        this.activityController = activityController;
    }

    @Override
    public void registerAutoCloseable(AutoCloseable closeable) {
        this.closeables.add(closeable);
    }

    @Override
    public void closeAutoCloseables() {
        for (AutoCloseable closeable : this.closeables) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Error closing " + closeable);
            }
        }
        this.closeables.clear();
    }

    @Override
    public RateLimiter getCycleLimiter() {
        return this.cycleLimiter;
    }

    @Override
    public synchronized void setCycleLimiter(RateLimiter rateLimiter) {
        this.cycleLimiter = rateLimiter;
    }

    @Override
    public synchronized RateLimiter getCycleRateLimiter(Supplier<? extends RateLimiter> s) {
        if (this.cycleLimiter == null) {
            this.cycleLimiter = s.get();
        }
        return this.cycleLimiter;
    }

    @Override
    public synchronized RateLimiter getStrideLimiter() {
        return this.strideLimiter;
    }

    @Override
    public synchronized void setStrideLimiter(RateLimiter rateLimiter) {
        this.strideLimiter = rateLimiter;
    }

    @Override
    public synchronized RateLimiter getStrideRateLimiter(Supplier<? extends RateLimiter> s) {
        if (this.strideLimiter == null) {
            this.strideLimiter = s.get();
        }
        return this.strideLimiter;
    }

    @Override
    public RateLimiter getPhaseLimiter() {
        return this.phaseLimiter;
    }

    @Override
    public Timer getResultTimer() {
        return ActivityMetrics.timer(this.getActivityDef(), "result");
    }

    @Override
    public void setPhaseLimiter(RateLimiter rateLimiter) {
        this.phaseLimiter = this.phaseLimiter;
    }

    @Override
    public synchronized RateLimiter getPhaseRateLimiter(Supplier<? extends RateLimiter> supplier) {
        if (this.phaseLimiter == null) {
            this.phaseLimiter = supplier.get();
        }
        return this.phaseLimiter;
    }

    @Override
    public synchronized ActivityInstrumentation getInstrumentation() {
        if (this.activityInstrumentation == null) {
            this.activityInstrumentation = new CoreActivityInstrumentation(this);
        }
        return this.activityInstrumentation;
    }

    @Override
    public synchronized void onActivityDefUpdate(ActivityDef activityDef) {
        activityDef.getParams().getOptionalNamedParameter("striderate").map(RateSpec::new).ifPresent(spec -> {
            this.strideLimiter = RateLimiters.createOrUpdate(this.getActivityDef(), "strides", this.strideLimiter, spec);
        });
        activityDef.getParams().getOptionalNamedParameter("cyclerate", "targetrate").map(RateSpec::new).ifPresent(spec -> {
            this.cycleLimiter = RateLimiters.createOrUpdate(this.getActivityDef(), "cycles", this.cycleLimiter, spec);
        });
        activityDef.getParams().getOptionalNamedParameter("phaserate").map(RateSpec::new).ifPresent(spec -> {
            this.phaseLimiter = RateLimiters.createOrUpdate(this.getActivityDef(), "phases", this.phaseLimiter, spec);
        });
    }

    public void setDefaultsFromOpSequence(OpSequence seq) {
        Optional<String> threadSpec;
        Optional<String> cyclesOpt;
        Optional<String> strideOpt = this.getParams().getOptionalString("stride");
        if (strideOpt.isEmpty()) {
            String stride = String.valueOf(seq.getSequence().length);
            logger.info("defaulting stride to " + stride + " (the sequence length)");
            this.getParams().set("stride", stride);
        }
        if ((cyclesOpt = this.getParams().getOptionalString("cycles")).isEmpty()) {
            String cycles = this.getParams().getOptionalString("stride").orElseThrow();
            logger.info("defaulting cycles to " + cycles + " (the stride length)");
            this.getParams().set("cycles", this.getParams().getOptionalString("stride").orElseThrow());
        } else {
            if (this.getActivityDef().getCycleCount() == 0L) {
                throw new RuntimeException("You specified cycles, but the range specified means zero cycles: " + this.getParams().get("cycles"));
            }
            long stride = this.getParams().getOptionalLong("stride").orElseThrow();
            long cycles = this.getActivityDef().getCycleCount();
            if (cycles < stride) {
                throw new RuntimeException("The specified cycles (" + cycles + ") are less than the stride (" + stride + "). This means there aren't enough cycles to cause a stride to be executed. If this was intended, then set stride low enough to allow it.");
            }
        }
        long cycleCount = this.getActivityDef().getCycleCount();
        long stride = this.getActivityDef().getParams().getOptionalLong("stride").orElseThrow();
        if (cycleCount % stride != 0L) {
            logger.warn("The stride does not evenly divide cycles. Only full strides will be executed,leaving some cycles unused.");
        }
        if ((threadSpec = this.activityDef.getParams().getOptionalString("threads")).isPresent()) {
            String spec = threadSpec.get();
            int processors = Runtime.getRuntime().availableProcessors();
            if (spec.toLowerCase().equals("auto")) {
                int threads = processors * 10;
                logger.info("setting threads to " + threads + " (auto)");
                this.activityDef.setThreads(threads);
            } else if (spec.toLowerCase().matches("\\d+x")) {
                String multiplier = spec.substring(0, spec.length() - 1);
                int threads = processors * Integer.parseInt(multiplier);
                logger.info("setting threads to " + threads + " (" + multiplier + "x)");
                this.activityDef.setThreads(threads);
            } else if (spec.toLowerCase().matches("\\d+")) {
                logger.info("setting threads to " + spec + "(direct)");
                this.activityDef.setThreads(Integer.parseInt(spec));
            }
        } else if (cycleCount > 1000L) {
            logger.warn("For testing at scale, it is highly recommended that you set threads to a value higher than the default of 1. hint: you can use threads=auto for reasonable default, or consult the topic on threads with `help threads` for more information.");
        }
    }
}

