/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.metrics;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import io.engineblock.metrics.ConvenientSnapshot;
import io.engineblock.metrics.DeltaHdrHistogramReservoir;
import io.engineblock.metrics.DeltaSnapshotReader;
import io.engineblock.metrics.DeltaSnapshotter;
import io.engineblock.metrics.HdrDeltaHistogramAttachment;
import io.engineblock.metrics.HistogramAttachment;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class NicerHistogram
extends Histogram
implements DeltaSnapshotter,
HdrDeltaHistogramAttachment,
HistogramAttachment {
    private final DeltaHdrHistogramReservoir hdrDeltaReservoir;
    private long cacheExpiryMillis = 0L;
    private long cacheTimeMillis = 0L;
    private String metricName;
    private List<Histogram> mirrors;

    public NicerHistogram(String metricName, DeltaHdrHistogramReservoir hdrHistogramReservoir) {
        super((Reservoir)hdrHistogramReservoir);
        this.metricName = metricName;
        this.hdrDeltaReservoir = hdrHistogramReservoir;
    }

    @Override
    public DeltaSnapshotReader getDeltaReader() {
        return new DeltaSnapshotReader(this);
    }

    public ConvenientSnapshot getSnapshot() {
        if (System.currentTimeMillis() < this.cacheExpiryMillis) {
            return new ConvenientSnapshot(this.hdrDeltaReservoir.getLastSnapshot());
        }
        return new ConvenientSnapshot(this.hdrDeltaReservoir.getSnapshot());
    }

    @Override
    public ConvenientSnapshot getDeltaSnapshot(long cacheTimeMillis) {
        this.cacheTimeMillis = cacheTimeMillis;
        this.cacheExpiryMillis = System.currentTimeMillis() + this.cacheTimeMillis;
        ConvenientSnapshot convenientSnapshot = new ConvenientSnapshot(this.hdrDeltaReservoir.getSnapshot());
        return convenientSnapshot;
    }

    @Override
    public synchronized NicerHistogram attachHdrDeltaHistogram() {
        if (this.mirrors == null) {
            this.mirrors = new CopyOnWriteArrayList<Histogram>();
        }
        DeltaHdrHistogramReservoir mirrorReservoir = this.hdrDeltaReservoir.copySettings();
        NicerHistogram mirror = new NicerHistogram("mirror-" + this.metricName, mirrorReservoir);
        this.mirrors.add(mirror);
        return mirror;
    }

    @Override
    public Histogram attachHistogram(Histogram histogram) {
        if (this.mirrors == null) {
            this.mirrors = new CopyOnWriteArrayList<Histogram>();
        }
        this.mirrors.add(histogram);
        return histogram;
    }

    public void update(long value) {
        super.update(value);
        if (this.mirrors != null) {
            for (Histogram mirror : this.mirrors) {
                mirror.update(value);
            }
        }
    }

    @Override
    public org.HdrHistogram.Histogram getNextHdrDeltaHistogram() {
        return this.hdrDeltaReservoir.getNextHdrHistogram();
    }
}

