/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.cli;

import io.engineblock.activityapi.core.ActivityType;
import io.engineblock.activityapi.cyclelog.outputs.cyclelog.CycleLogDumperUtility;
import io.engineblock.activityapi.cyclelog.outputs.cyclelog.CycleLogImporterUtility;
import io.engineblock.activityapi.input.InputType;
import io.engineblock.activityapi.output.OutputType;
import io.engineblock.cli.ConsoleLogging;
import io.engineblock.cli.EBCLIOptions;
import io.engineblock.cli.EBCLIScriptAssembly;
import io.engineblock.cli.VersionInfo;
import io.engineblock.core.MarkdownDocInfo;
import io.engineblock.core.ScenarioLogger;
import io.engineblock.core.ScenariosResults;
import io.engineblock.core.ShutdownManager;
import io.engineblock.metrics.ActivityMetrics;
import io.engineblock.metrics.MetricReporters;
import io.engineblock.script.MetricsMapper;
import io.engineblock.script.Scenario;
import io.engineblock.script.ScenariosExecutor;
import io.engineblock.util.Named;
import io.virtdata.apps.MainRouting;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBCLI {
    private static final Logger logger = LoggerFactory.getLogger(EBCLI.class);
    private String commandName;

    public EBCLI(String commandName) {
        this.commandName = commandName;
    }

    public static void main(String[] args) {
        EBCLI cli = new EBCLI("eb");
        cli.run(args);
    }

    public void run(String[] args) {
        EBCLIOptions options;
        if (args.length > 0 && args[0].toLowerCase().equals("virtdata")) {
            MainRouting.main((String[])Arrays.copyOfRange(args, 1, args.length));
            System.exit(0);
        }
        if ((options = new EBCLIOptions(args)).wantsBasicHelp()) {
            System.out.println(this.loadHelpFile("commandline.md"));
            System.exit(0);
        }
        if (options.wantsAdvancedHelp()) {
            System.out.println(this.loadHelpFile("cli_scripting.md"));
            System.exit(0);
        }
        if (options.wantsVersion()) {
            System.out.println(new VersionInfo().getVersion());
            System.out.println(new VersionInfo().getArtifactCoordinates());
            System.exit(0);
        }
        if (options.wantsActivityTypes()) {
            ActivityType.FINDER.getAll().stream().map(ActivityType::getName).forEach(System.out::println);
            System.exit(0);
        }
        if (options.wantsInputTypes()) {
            InputType.FINDER.getAll().stream().map(Named::getName).forEach(System.out::println);
            System.exit(0);
        }
        if (options.wantsMarkerTypes()) {
            OutputType.FINDER.getAll().stream().map(Named::getName).forEach(System.out::println);
            System.exit(0);
        }
        if (options.wantsToDumpCyclelog()) {
            CycleLogDumperUtility.main((String[])options.getCycleLogExporterOptions());
            System.exit(0);
        }
        if (options.wantsToImportCycleLog()) {
            CycleLogImporterUtility.main((String[])options.getCyclelogImportOptions());
            System.exit(0);
        }
        if (options.wantsTopicalHelp()) {
            Optional helpDoc = MarkdownDocInfo.forHelpTopic((String)options.wantsTopicalHelpFor());
            System.out.println((String)helpDoc.orElseThrow(() -> new RuntimeException("No help could be found for " + options.wantsTopicalHelpFor())));
            System.exit(0);
        }
        if (options.wantsMetricsForActivity() != null) {
            String metricsHelp = this.getMetricsHelpFor(options.wantsMetricsForActivity());
            System.out.println("Available metric names for activity:" + options.wantsMetricsForActivity() + ":");
            System.out.println(metricsHelp);
            System.exit(0);
        }
        if (options.wantsReportGraphiteTo() != null || options.wantsReportCsvTo() != null) {
            MetricReporters reporters = MetricReporters.getInstance();
            reporters.addRegistry("workloads", ActivityMetrics.getMetricRegistry());
            if (options.wantsReportGraphiteTo() != null) {
                reporters.addGraphite(options.wantsReportGraphiteTo(), options.wantsMetricsPrefix());
            }
            if (options.wantsReportCsvTo() != null) {
                reporters.addCSVReporter(options.wantsReportCsvTo(), options.wantsMetricsPrefix());
            }
            reporters.start(10, options.getReportInterval());
        }
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sessionName = "scenario-" + timestamp;
        if (!options.getSessionName().isEmpty()) {
            sessionName = options.getSessionName();
        }
        for (EBCLIOptions.LoggerConfig histoLogger : options.getHistoLoggerConfigs()) {
            ActivityMetrics.addHistoLogger((String)sessionName, (String)histoLogger.pattern, (String)histoLogger.file, (String)histoLogger.interval);
        }
        for (EBCLIOptions.LoggerConfig statsLogger : options.getStatsLoggerConfigs()) {
            ActivityMetrics.addStatsLogger((String)sessionName, (String)statsLogger.pattern, (String)statsLogger.file, (String)statsLogger.interval);
        }
        for (EBCLIOptions.LoggerConfig classicConfigs : options.getClassicHistoConfigs()) {
            ActivityMetrics.addClassicHistos((String)sessionName, (String)classicConfigs.pattern, (String)classicConfigs.file, (String)classicConfigs.interval);
        }
        ConsoleLogging.enableConsoleLogging(options.wantsConsoleLogLevel(), options.getConsoleLoggingPattern());
        logger.info("console logging level is " + options.wantsConsoleLogLevel());
        if (options.getCommands().size() == 0) {
            System.out.println(this.loadHelpFile("commandline.md"));
            System.exit(0);
        }
        ScenariosExecutor executor = new ScenariosExecutor("executor-" + sessionName, 1);
        Scenario scenario = new Scenario(sessionName, options.getProgressSpec());
        EBCLIScriptAssembly.ScriptData scriptData = EBCLIScriptAssembly.assembleScript(options);
        if (options.wantsShowScript()) {
            System.out.println("// Rendered Script");
            System.out.println(scriptData.getScriptParamsAndText());
            System.exit(0);
        }
        scenario.addScenarioScriptParams(scriptData.getScriptParams());
        scenario.addScriptText(scriptData.getScriptTextIgnoringParams());
        ScenarioLogger sl = new ScenarioLogger(scenario).setLogDir(options.getLogsDirectory()).setMaxLogs(options.getLogsMax()).setLevel(options.getLogsLevel()).setLogLevelOverrides(options.getLogLevelOverrides()).start();
        executor.execute(scenario, sl);
        ScenariosResults scenariosResults = executor.awaitAllResults();
        ActivityMetrics.closeMetrics();
        scenariosResults.reportToLog();
        ShutdownManager.shutdown();
        if (scenariosResults.hasError()) {
            System.exit(2);
        } else {
            System.exit(0);
        }
    }

    private String loadHelpFile(String filename) {
        String basicHelp;
        ClassLoader cl = this.getClass().getClassLoader();
        InputStream resourceAsStream = cl.getResourceAsStream(filename);
        if (resourceAsStream == null) {
            throw new RuntimeException("Unable to find " + filename + " in classpath.");
        }
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(resourceAsStream));){
            basicHelp = buffer.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to buffer " + filename + ": " + t);
        }
        basicHelp = basicHelp.replaceAll("PROG", this.commandName);
        return basicHelp;
    }

    private String getMetricsHelpFor(String activityType) {
        String metrics = MetricsMapper.metricsDetail((String)activityType);
        return metrics;
    }
}

