/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.script;

import com.codahale.metrics.MetricRegistry;
import io.engineblock.activitycore.ProgressIndicator;
import io.engineblock.core.ScenarioController;
import io.engineblock.core.ScenarioLogger;
import io.engineblock.core.ScenarioResult;
import io.engineblock.extensions.ScriptingPluginInfo;
import io.engineblock.metrics.ActivityMetrics;
import io.engineblock.metrics.MetricRegistryBindings;
import io.engineblock.script.SandboxExtensionFinder;
import io.engineblock.script.ScenarioBindings;
import io.engineblock.script.ScenarioContext;
import io.engineblock.scripting.ScriptEnvBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scenario
implements Callable<ScenarioResult> {
    private static final ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger(Scenario.class);
    private static final ScriptEngineManager engineManager = new ScriptEngineManager();
    private final List<String> scripts = new ArrayList<String>();
    private ScriptEngine scriptEngine;
    private ScenarioController scenarioController;
    private ProgressIndicator progressIndicator;
    private String progressInterval = "console:1m";
    private ScenarioContext scriptEnv;
    private String name;
    private ScenarioLogger scenarioLogger;

    public Scenario(String name, String progressInterval) {
        this.name = name;
        this.progressInterval = progressInterval;
        this.init();
    }

    public Scenario(String name) {
        this.name = name;
        this.init();
    }

    public Scenario addScriptText(String scriptText) {
        this.scripts.add(scriptText);
        return this;
    }

    public Scenario addScriptFiles(String ... args) {
        for (String scriptFile : args) {
            Path scriptPath = Paths.get(scriptFile, new String[0]);
            byte[] bytes = new byte[]{};
            try {
                bytes = Files.readAllBytes(scriptPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            Charset utf8 = Charset.forName("UTF8");
            String scriptData = utf8.decode(bb).toString();
            this.addScriptText(scriptData);
        }
        return this;
    }

    private void init() {
        MetricRegistry metricRegistry = ActivityMetrics.getMetricRegistry();
        this.scriptEngine = engineManager.getEngineByName("nashorn");
        this.scriptEnv = new ScenarioContext(this.scenarioController);
        this.scriptEngine.setContext((ScriptContext)((Object)this.scriptEnv));
        this.scenarioController = new ScenarioController();
        this.progressIndicator = new ProgressIndicator(this.scenarioController, this.progressInterval);
        this.scriptEngine.put("scenario", this.scenarioController);
        this.scriptEngine.put("activities", new ScenarioBindings(this.scenarioController));
        this.scriptEngine.put("metrics", new MetricRegistryBindings(metricRegistry));
        for (ScriptingPluginInfo<?> extensionDescriptor : SandboxExtensionFinder.findAll()) {
            if (!extensionDescriptor.isAutoLoading()) {
                logger.info("Not loading " + extensionDescriptor + ", autoloading is false");
                continue;
            }
            Logger extensionLogger = LoggerFactory.getLogger((String)("extensions." + extensionDescriptor.getBaseVariableName()));
            Object extensionObject = extensionDescriptor.getExtensionObject(extensionLogger, metricRegistry, (ScriptContext)((Object)this.scriptEnv));
            logger.debug("Adding extension object:  name=" + extensionDescriptor.getBaseVariableName() + " class=" + extensionObject.getClass().getSimpleName());
            this.scriptEngine.put(extensionDescriptor.getBaseVariableName(), extensionObject);
        }
    }

    public void run() {
        logger.info("Running control script for " + this.getName() + ".");
        for (String script : this.scripts) {
            String errorDesc;
            try {
                Object result = null;
                if (this.scriptEngine instanceof Compilable) {
                    logger.info("Using direct script compilation");
                    Compilable compilableEngine = (Compilable)((Object)this.scriptEngine);
                    CompiledScript compiled = compilableEngine.compile(script);
                    result = compiled.eval();
                    continue;
                }
                result = this.scriptEngine.eval(script);
            }
            catch (ScriptException e) {
                errorDesc = "Script error while running scenario:" + e.getMessage();
                e.printStackTrace();
                logger.error(errorDesc, (Throwable)e);
                this.scenarioController.forceStopScenario(5000);
                throw new RuntimeException("Script error while running scenario:" + e.getMessage(), e);
            }
            catch (Exception o) {
                errorDesc = "Non-Script error while running scenario:" + o.getMessage();
                o.printStackTrace();
                logger.error(errorDesc, (Throwable)o);
                this.scenarioController.forceStopScenario(5000);
                throw new RuntimeException("Non-Script error while running scenario:" + o.getMessage(), o);
            }
        }
        int awaitCompletionTime = 1471228928;
        logger.info("Awaiting completion of scenario for " + awaitCompletionTime + " millis.");
        this.scenarioController.awaitCompletion(awaitCompletionTime);
    }

    @Override
    public ScenarioResult call() {
        this.run();
        String iolog = this.scriptEnv.getTimedLog();
        return new ScenarioResult(iolog);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scenario scenario = (Scenario)o;
        return this.getName() != null ? this.getName().equals(scenario.getName()) : scenario.getName() == null;
    }

    public int hashCode() {
        return this.getName() != null ? this.getName().hashCode() : 0;
    }

    public String getName() {
        return this.name;
    }

    public ScenarioController getScenarioController() {
        return this.scenarioController;
    }

    public String getScriptText() {
        return this.scripts.stream().collect(Collectors.joining());
    }

    public Optional<List<String>> getIOLog() {
        return Optional.ofNullable(this.scriptEnv).map(ScriptEnvBuffer::getTimeLogLines);
    }

    public String toString() {
        return "name:'" + this.getName() + "'";
    }

    public void setScenarioLogger(ScenarioLogger scenarioLogger) {
        this.scenarioLogger = scenarioLogger;
    }
}

