/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.core;

import io.engineblock.core.ScenarioResult;
import io.engineblock.script.Scenario;
import io.engineblock.script.ScenariosExecutor;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScenariosResults {
    private static final Logger logger = LoggerFactory.getLogger(ScenariosResults.class);
    private String scenariosExecutorName;
    private Map<Scenario, ScenarioResult> scenarioResultMap = new LinkedHashMap<Scenario, ScenarioResult>();

    public ScenariosResults(ScenariosExecutor scenariosExecutor) {
        this.scenariosExecutorName = scenariosExecutor.getName();
    }

    public ScenariosResults(ScenariosExecutor scenariosExecutor, Map<Scenario, ScenarioResult> map) {
        this.scenariosExecutorName = scenariosExecutor.getName();
        this.scenarioResultMap.putAll(map);
    }

    public ScenarioResult getOne() {
        if (this.scenarioResultMap.size() != 1) {
            throw new RuntimeException("getOne found " + this.scenarioResultMap.size() + " results instead of 1.");
        }
        return this.scenarioResultMap.values().stream().findFirst().orElseThrow(() -> new RuntimeException("Missing result."));
    }

    public void reportToLog() {
        for (Map.Entry<Scenario, ScenarioResult> entry : this.scenarioResultMap.entrySet()) {
            Scenario scenario = entry.getKey();
            ScenarioResult oresult = entry.getValue();
            logger.info("results for scenario: " + scenario);
            if (oresult != null) {
                oresult.reportToLog();
                continue;
            }
            logger.error(scenario.getName() + ": incomplete (missing result)");
        }
    }

    public boolean hasError() {
        return this.scenarioResultMap.values().stream().anyMatch(r -> r.getException().isPresent());
    }
}

