/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection.emit;

import com.strobel.core.ArrayUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.core.delegates.Func1;
import com.strobel.reflection.ConstructorInfo;
import com.strobel.reflection.FieldInfo;
import com.strobel.reflection.MethodBase;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.PrimitiveTypes;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeList;
import com.strobel.reflection.Types;
import com.strobel.reflection.emit.CodeStream;
import com.strobel.reflection.emit.ConstructorBuilder;
import com.strobel.reflection.emit.EnumSwitchCallback;
import com.strobel.reflection.emit.Error;
import com.strobel.reflection.emit.Label;
import com.strobel.reflection.emit.LocalBuilder;
import com.strobel.reflection.emit.MethodBuilder;
import com.strobel.reflection.emit.OpCode;
import com.strobel.reflection.emit.OperandType;
import com.strobel.reflection.emit.ScopeTree;
import com.strobel.reflection.emit.StringSwitchCallback;
import com.strobel.reflection.emit.SwitchCallback;
import com.strobel.reflection.emit.SwitchOptions;
import com.strobel.reflection.emit.TypeBuilder;
import com.strobel.reflection.emit.__ExceptionInfo;
import com.strobel.reflection.emit.__FixupData;
import com.strobel.util.ContractUtils;
import com.strobel.util.TypeUtils;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.lang.model.type.TypeKind;

public class CodeGenerator {
    static final int DefaultSize = 64;
    static final int DefaultFixupArraySize = 64;
    static final int DefaultLabelArraySize = 16;
    static final int DefaultExceptionArraySize = 8;
    private static final int MIN_BYTE = 0;
    private static final int MAX_BYTE = 255;
    private CodeStream _codeStream;
    private int[] _labelList;
    private int _labelCount;
    private __FixupData[] _fixupData;
    private int _fixupCount;
    private int _exceptionCount;
    private int _currentExceptionStackCount;
    private int _unhandledExceptionCount;
    private __ExceptionInfo[] _exceptions;
    private __ExceptionInfo[] _currentExceptionStack;
    private Type<?>[] _unhandledExceptions;
    ScopeTree scopeTree;
    final MethodBuilder methodBuilder;
    int localCount;
    LocalBuilder[] locals;
    private int _maxStackSize = 0;
    private int _maxMidStack = 0;
    private int _maxMidStackCur = 0;
    private static final MethodInfo StringCharAtMethod = Types.String.getMethod("charAt", PrimitiveTypes.Integer);
    private static final MethodInfo StringLengthMethod = Types.String.getMethod("length", new Type[0]);
    private static final MethodInfo ObjectEqualsMethod = Types.Object.getMethod("equals", Types.Object);
    private static final MethodInfo ObjectHashCodeMethod = Types.Object.getMethod("hashCode", new Type[0]);

    public CodeGenerator(MethodBuilder methodBuilder) {
        this(methodBuilder, 64);
    }

    public CodeGenerator(MethodBuilder methodBuilder, int initialSize) {
        this.methodBuilder = VerifyArgument.notNull(methodBuilder, "methodBuilder");
        this._codeStream = initialSize < 64 ? new CodeStream(64) : new CodeStream(initialSize);
        this.scopeTree = new ScopeTree();
    }

    public int offset() {
        return this._codeStream.getLength();
    }

    public Label beginExceptionBlock() {
        if (this._exceptions == null) {
            this._exceptions = new __ExceptionInfo[8];
        }
        if (this._currentExceptionStack == null) {
            this._currentExceptionStack = new __ExceptionInfo[8];
        }
        if (this._exceptionCount >= this._exceptions.length) {
            this._exceptions = CodeGenerator.enlargeArray(this._exceptions);
        }
        if (this._currentExceptionStackCount >= this._currentExceptionStack.length) {
            this._currentExceptionStack = CodeGenerator.enlargeArray(this._currentExceptionStack);
        }
        Label endLabel = this.defineLabel();
        __ExceptionInfo exceptionInfo = new __ExceptionInfo(this.offset(), endLabel);
        this._exceptions[this._exceptionCount++] = exceptionInfo;
        this._currentExceptionStack[this._currentExceptionStackCount++] = exceptionInfo;
        return endLabel;
    }

    public void endExceptionBlock() {
        if (this._currentExceptionStackCount == 0) {
            throw Error.notInExceptionBlock();
        }
        __ExceptionInfo current = this._currentExceptionStack[this._currentExceptionStackCount - 1];
        this._currentExceptionStack[this._currentExceptionStackCount - 1] = null;
        --this._currentExceptionStackCount;
        Label endLabel = current.getEndLabel();
        int state = current.getCurrentState();
        if (state == 1 || state == 0) {
            throw Error.badExceptionCodeGenerated();
        }
        if (this._labelList[endLabel.getLabelValue()] == -1) {
            this.markLabel(endLabel);
        } else {
            this.markLabel(current.getFinallyEndLabel());
        }
        current.done(this.offset());
    }

    public void endTryBlock() {
        if (this._currentExceptionStackCount == 0) {
            throw Error.notInExceptionBlock();
        }
        __ExceptionInfo current = this._currentExceptionStack[this._currentExceptionStackCount - 1];
        current.markTryEndAddress(this.offset());
    }

    public void beginCatchBlock(Type<?> caughtType) {
        VerifyArgument.notNull(caughtType, "caughtType");
        if (this._currentExceptionStackCount == 0) {
            throw Error.notInExceptionBlock();
        }
        if (!Types.Throwable.isAssignableFrom(caughtType)) {
            throw Error.catchRequiresThrowableType();
        }
        __ExceptionInfo current = this._currentExceptionStack[this._currentExceptionStackCount - 1];
        this.emit(OpCode.GOTO, current.getEndLabel());
        current.markCatchAddress(this.offset(), caughtType);
    }

    public void beginFinallyBlock() {
        if (this._currentExceptionStackCount == 0) {
            throw Error.notInExceptionBlock();
        }
        __ExceptionInfo current = this._currentExceptionStack[this._currentExceptionStackCount - 1];
        int state = current.getCurrentState();
        int catchEndAddress = 0;
        if (state != 0) {
            catchEndAddress = this.offset();
        }
        Label finallyEndLabel = this.defineLabel();
        current.setFinallyEndLabel(finallyEndLabel);
        Label endLabel = current.getEndLabel();
        this.markLabel(endLabel);
        this.emit(OpCode.GOTO, current.getFinallyEndLabel());
        if (catchEndAddress == 0) {
            catchEndAddress = this.offset();
        }
        current.markFinallyAddress(this.offset(), catchEndAddress);
    }

    public Label defineLabel() {
        if (this._labelList == null) {
            this._labelList = new int[16];
        }
        if (this._labelCount >= this._labelList.length) {
            this._labelList = CodeGenerator.enlargeArray(this._labelList);
        }
        this._labelList[this._labelCount] = -1;
        return new Label(this._labelCount++);
    }

    public void markLabel(Label label) {
        int labelIndex = label.getLabelValue();
        if (labelIndex < 0 || labelIndex >= this._labelList.length) {
            throw Error.badLabel();
        }
        if (this._labelList[labelIndex] != -1) {
            throw Error.labelAlreadyDefined();
        }
        this._labelList[labelIndex] = this._codeStream.getLength();
    }

    public LocalBuilder declareLocal(Type<?> localType) {
        return this.declareLocal(null, localType);
    }

    public LocalBuilder declareLocal(String name, Type<?> localType) {
        VerifyArgument.notNull(localType, "localType");
        MethodBuilder methodBuilder = this.methodBuilder;
        if (methodBuilder == null) {
            throw Error.bytecodeGeneratorNotOwnedByMethodBuilder();
        }
        if (methodBuilder.isTypeCreated()) {
            throw Error.typeHasBeenCreated();
        }
        if (methodBuilder.isFinished()) {
            throw Error.methodIsFinished();
        }
        LocalBuilder localBuilder = new LocalBuilder(this.localCount, name, localType, methodBuilder);
        ++this.localCount;
        if (this.locals == null) {
            this.locals = new LocalBuilder[16];
        } else if (this.locals.length < this.localCount) {
            this.locals = CodeGenerator.enlargeArray(this.locals);
        }
        this.locals[this.localCount - 1] = localBuilder;
        return localBuilder;
    }

    public void dup() {
        this.emit(OpCode.DUP);
    }

    public void dup2() {
        this.emit(OpCode.DUP2);
    }

    public void dup2x1() {
        this.emit(OpCode.DUP2_X1);
    }

    public void dup2x2() {
        this.emit(OpCode.DUP2_X2);
    }

    public void pop() {
        this.emit(OpCode.POP);
    }

    public void pop2() {
        this.emit(OpCode.POP2);
    }

    public void pop(Type<?> type) {
        switch (type.getKind()) {
            case LONG: 
            case DOUBLE: {
                this.emit(OpCode.POP2);
                break;
            }
            case VOID: {
                break;
            }
            default: {
                this.emit(OpCode.POP);
            }
        }
    }

    public void emit(OpCode opCode) {
        this.ensureCapacity(opCode.getSizeWithOperands());
        this.internalEmit(opCode);
    }

    public void emit(OpCode opCode, byte arg) {
        this.emit(opCode);
        this.emitByteOperand(arg);
    }

    public void emit(OpCode opCode, short arg) {
        this.emit(opCode);
        this.emitShortOperand(arg);
    }

    public void emit(OpCode opCode, int arg) {
        this.emit(opCode);
        this.emitIntOperand(arg);
    }

    public void emit(OpCode opCode, long arg) {
        this.emit(opCode);
        this.emitLongOperand(arg);
    }

    public void emit(OpCode opCode, float arg) {
        this.emit(opCode);
        this.emitFloatOperand(arg);
    }

    public void emit(OpCode opCode, double arg) {
        this.emit(opCode);
        this.emitDoubleOperand(arg);
    }

    public void emit(OpCode opCode, String arg) {
        this.emit(opCode);
        this.emitString(arg);
    }

    public void emit(OpCode opCode, Type<?> type) {
        VerifyArgument.notNull(type, "type");
        MethodBuilder methodBuilder = this.methodBuilder;
        if (methodBuilder == null) {
            throw Error.bytecodeGeneratorNotOwnedByMethodBuilder();
        }
        short typeToken = ((TypeBuilder)methodBuilder.getDeclaringType()).getTypeToken(type);
        this.emit(opCode, typeToken);
    }

    public void emit(OpCode opCode, ConstructorInfo constructor) {
        VerifyArgument.notNull(constructor, "constructor");
        MethodBuilder methodBuilder = this.methodBuilder;
        if (methodBuilder == null) {
            throw Error.bytecodeGeneratorNotOwnedByMethodBuilder();
        }
        short methodToken = ((TypeBuilder)methodBuilder.getDeclaringType()).getMethodToken(constructor);
        this.emit(opCode, methodToken);
        this.registerCheckedExceptions(constructor);
        int stackChange = 0;
        stackChange = constructor instanceof ConstructorBuilder ? (stackChange -= ((ConstructorBuilder)constructor).getParameterTypes().size()) : (stackChange -= constructor.getParameters().size());
        this.updateStackSize(opCode, stackChange);
    }

    public void emit(OpCode opCode, MethodInfo method) {
        VerifyArgument.notNull(method, "method");
        MethodBuilder methodBuilder = this.methodBuilder;
        if (methodBuilder == null) {
            throw Error.bytecodeGeneratorNotOwnedByMethodBuilder();
        }
        short methodToken = ((TypeBuilder)methodBuilder.getDeclaringType()).getMethodToken(method);
        this.emit(opCode, methodToken);
        int formalParametersSize = 0;
        TypeList parameterTypes = method instanceof MethodBuilder ? ((MethodBuilder)method).getParameterTypes() : method.getParameters().getParameterTypes();
        for (Type parameterType : parameterTypes) {
            ++formalParametersSize;
            if (parameterType != PrimitiveTypes.Long && parameterType != PrimitiveTypes.Double) continue;
            ++formalParametersSize;
        }
        if (opCode == OpCode.INVOKEINTERFACE) {
            int argsSize = 1 + formalParametersSize;
            this.emitByteOperand((byte)argsSize);
            this.emitByteOperand(0);
        }
        this.registerCheckedExceptions(method);
        int stackChange = -formalParametersSize;
        Type<?> returnType = method.getReturnType();
        if (returnType != PrimitiveTypes.Void) {
            ++stackChange;
            if (returnType == PrimitiveTypes.Long || returnType == PrimitiveTypes.Double) {
                ++stackChange;
            }
        }
        this.updateStackSize(opCode, stackChange);
    }

    public void emit(OpCode opCode, FieldInfo field) {
        VerifyArgument.notNull(field, "field");
        MethodBuilder methodBuilder = this.methodBuilder;
        if (methodBuilder == null) {
            throw Error.bytecodeGeneratorNotOwnedByMethodBuilder();
        }
        short fieldToken = ((TypeBuilder)methodBuilder.getDeclaringType()).getFieldToken(field);
        this.emit(opCode, fieldToken);
    }

    public void emit(OpCode opCode, Label label) {
        VerifyArgument.notNull(label, "label");
        int tempVal = label.getLabelValue();
        int fixupOrigin = this._codeStream.getLength();
        this.emit(opCode);
        if (opCode.getOperandType() == OperandType.Branch) {
            this.addFixup(label, fixupOrigin, this._codeStream.getLength(), 2);
            this._codeStream.putShort(0);
        } else if (opCode.getOperandType() == OperandType.BranchW) {
            this.addFixup(label, fixupOrigin, this._codeStream.getLength(), 4);
            this._codeStream.putInt(0);
        }
    }

    public void call(MethodInfo method) {
        VerifyArgument.notNull(method, "method");
        if (method.isStatic()) {
            this.emit(OpCode.INVOKESTATIC, method);
        } else if (method.isPrivate()) {
            this.emit(OpCode.INVOKESPECIAL, method);
        } else if (method.getDeclaringType().isInterface()) {
            this.emit(OpCode.INVOKEINTERFACE, method);
        } else {
            this.emit(OpCode.INVOKEVIRTUAL, method);
        }
    }

    public void call(ConstructorInfo constructor) {
        this.emit(OpCode.INVOKESPECIAL, constructor);
    }

    public void call(OpCode opCode, MethodInfo method) {
        VerifyArgument.notNull(method, "method");
        switch (opCode) {
            case INVOKEDYNAMIC: 
            case INVOKEINTERFACE: 
            case INVOKESPECIAL: 
            case INVOKESTATIC: 
            case INVOKEVIRTUAL: {
                break;
            }
            default: {
                throw Error.invokeOpCodeRequired();
            }
        }
        this.emit(opCode, method);
    }

    public void emitGoto(Label label) {
        this.emit(OpCode.GOTO, label);
    }

    public void emitReturn() {
        this.emit(OpCode.RETURN);
    }

    public void emitReturn(Type<?> returnType) {
        OpCode opCode;
        VerifyArgument.notNull(returnType, "returnType");
        switch (returnType.getKind()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case CHAR: {
                opCode = OpCode.IRETURN;
                break;
            }
            case LONG: {
                opCode = OpCode.LRETURN;
                break;
            }
            case FLOAT: {
                opCode = OpCode.FRETURN;
                break;
            }
            case DOUBLE: {
                opCode = OpCode.DRETURN;
                break;
            }
            case VOID: {
                opCode = OpCode.RETURN;
                break;
            }
            default: {
                opCode = OpCode.ARETURN;
            }
        }
        this.emit(opCode);
    }

    public void emitNew(Type<?> type) {
        VerifyArgument.notNull(type, "type");
        if (type.containsGenericParameters()) {
            throw Error.cannotInstantiateUnboundGenericType(type);
        }
        if (type.isPrimitive()) {
            this.emitDefaultValue(type);
            return;
        }
        this.emit(OpCode.NEW, type);
    }

    public void emitNewArray(Type<?> arrayType) {
        VerifyArgument.notNull(arrayType, "arrayType");
        if (!arrayType.isArray()) {
            throw Error.typeMustBeArray();
        }
        Type<?> elementType = arrayType.getElementType();
        int rank = 1;
        while (elementType.isArray()) {
            ++rank;
            elementType = elementType.getElementType();
        }
        this.emitNewArray(arrayType, rank);
    }

    public void emitNewArray(Type<?> arrayType, int dimensionsToInitialize) {
        VerifyArgument.notNull(arrayType, "arrayType");
        VerifyArgument.isPositive(dimensionsToInitialize, "dimensionsToInitialize");
        if (dimensionsToInitialize == 1) {
            Type<?> elementType = arrayType.getElementType();
            if (elementType.isPrimitive()) {
                byte typeCode;
                switch (elementType.getKind()) {
                    case BOOLEAN: {
                        typeCode = 4;
                        break;
                    }
                    case BYTE: {
                        typeCode = 8;
                        break;
                    }
                    case SHORT: {
                        typeCode = 9;
                        break;
                    }
                    case INT: {
                        typeCode = 10;
                        break;
                    }
                    case LONG: {
                        typeCode = 11;
                        break;
                    }
                    case CHAR: {
                        typeCode = 5;
                        break;
                    }
                    case FLOAT: {
                        typeCode = 6;
                        break;
                    }
                    case DOUBLE: {
                        typeCode = 7;
                        break;
                    }
                    default: {
                        throw ContractUtils.unreachable();
                    }
                }
                this.emit(OpCode.NEWARRAY, typeCode);
            } else {
                this.emit(OpCode.ANEWARRAY, elementType);
            }
            return;
        }
        int dimension = dimensionsToInitialize;
        Type<?> elementType = arrayType.getElementType();
        while (--dimension > 0) {
            if (!elementType.isArray()) {
                throw Error.newArrayDimensionsOutOfRange(arrayType, dimensionsToInitialize);
            }
            elementType = elementType.getElementType();
        }
        this.emit(OpCode.MULTIANEWARRAY, arrayType);
        this.emitByteOperand(dimensionsToInitialize);
    }

    public final void emitArray(Type<?> elementType, int count, EmitArrayElementCallback emit) {
        VerifyArgument.notNull(elementType, "elementType");
        VerifyArgument.notNull(emit, "emit");
        VerifyArgument.isNonNegative(count, "count");
        this.emitInteger(count);
        this.emitNewArray(elementType.makeArrayType());
        for (int i = 0; i < count; ++i) {
            this.dup();
            this.emitInteger(i);
            emit.emit(i);
            this.emitStoreElement(elementType);
        }
    }

    public void increment(LocalBuilder local, int delta) {
        VerifyArgument.notNull(local, "local");
        int localIndex = this.translateLocal(local.getLocalIndex());
        if (local.startOffset < 0) {
            local.startOffset = this.offset();
        }
        if (localIndex < 255 && delta <= 127 && delta >= -128) {
            this.emit(OpCode.IINC);
            this.emitByteOperand(localIndex);
            this.emitByteOperand(delta);
        } else {
            this.emit(OpCode.IINC_W);
            this.emitShortOperand(localIndex);
            this.emitShortOperand(delta);
        }
        local.endOffset = this.offset();
    }

    public void emitLoad(LocalBuilder local) {
        VerifyArgument.notNull(local, "local");
        if (local.getMethodBuilder() != this.methodBuilder) {
            throw Error.unmatchedLocal();
        }
        if (local.startOffset < 0) {
            local.startOffset = this.offset();
        }
        this.emitLoad(local.getLocalType(), this.translateLocal(local.getLocalIndex()));
        local.endOffset = this.offset();
    }

    public void emitStore(LocalBuilder local) {
        VerifyArgument.notNull(local, "local");
        if (local.getMethodBuilder() != this.methodBuilder) {
            throw Error.unmatchedLocal();
        }
        if (local.startOffset < 0) {
            local.startOffset = this.offset();
        }
        this.emitStore(local.getLocalType(), this.translateLocal(local.getLocalIndex()));
        local.endOffset = this.offset();
    }

    public void emitThis() {
        if (this.methodBuilder == null) {
            throw Error.bytecodeGeneratorNotOwnedByMethodBuilder();
        }
        if (this.methodBuilder.isStatic()) {
            throw Error.cannotLoadThisForStaticMethod();
        }
        this.emitLoad(this.methodBuilder.getDeclaringType(), 0);
    }

    public void emitLoadArgument(int index) {
        assert (index >= 0) : "index >= 0";
        if (this.methodBuilder == null) {
            throw Error.bytecodeGeneratorNotOwnedByMethodBuilder();
        }
        TypeList parameterTypes = this.methodBuilder.getParameterTypes();
        if (index < 0 || index >= parameterTypes.size()) {
            throw Error.argumentIndexOutOfRange(this.methodBuilder, index);
        }
        int absoluteIndex = this.translateParameter(index);
        OpCode opCode = CodeGenerator.getLocalLoadOpCode((Type)parameterTypes.get(index), absoluteIndex);
        this.internalEmit(opCode);
        if (opCode.getOperandType() == OperandType.NoOperands) {
            return;
        }
        if (absoluteIndex > 255) {
            this.emitShortOperand(absoluteIndex);
        } else {
            this.emitByteOperand(absoluteIndex);
        }
    }

    protected void emitLoad(Type<?> type, int absoluteIndex) {
        assert (absoluteIndex >= 0) : "absoluteIndex >= 0";
        OpCode optimalOpCode = CodeGenerator.getLocalLoadOpCode(type, absoluteIndex);
        this.emit(optimalOpCode);
        OperandType operandType = optimalOpCode.getOperandType();
        if (operandType == OperandType.NoOperands) {
            return;
        }
        if (absoluteIndex > 255) {
            this.emitShortOperand(absoluteIndex);
        } else {
            this.emitByteOperand(absoluteIndex);
        }
    }

    public void emitStoreArgument(int index) {
        assert (index >= 0) : "index >= 0";
        if (this.methodBuilder == null) {
            throw Error.bytecodeGeneratorNotOwnedByMethodBuilder();
        }
        TypeList parameterTypes = this.methodBuilder.getParameterTypes();
        if (index < 0 || index >= parameterTypes.size()) {
            throw Error.argumentIndexOutOfRange(this.methodBuilder, index);
        }
        int absoluteIndex = this.translateParameter(index);
        OpCode opCode = CodeGenerator.getLocalStoreOpCode((Type)parameterTypes.get(index), absoluteIndex);
        this.internalEmit(opCode);
        if (opCode.getOperandType() == OperandType.NoOperands) {
            return;
        }
        if (absoluteIndex > 255) {
            this.emitShortOperand(absoluteIndex);
        } else {
            this.emitByteOperand(absoluteIndex);
        }
    }

    protected void emitStore(Type<?> type, int absoluteIndex) {
        assert (absoluteIndex >= 0) : "absoluteIndex >= 0";
        OpCode optimalOpCode = CodeGenerator.getLocalStoreOpCode(type, absoluteIndex);
        this.emit(optimalOpCode);
        OperandType operandType = optimalOpCode.getOperandType();
        if (operandType == OperandType.NoOperands) {
            return;
        }
        if (absoluteIndex > 255) {
            this.emitShortOperand(absoluteIndex);
        } else {
            this.emitByteOperand(absoluteIndex);
        }
    }

    private static OpCode getLocalLoadOpCode(Type<?> type, int localIndex) {
        switch (type.getKind()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case CHAR: {
                switch (localIndex) {
                    case 0: {
                        return OpCode.ILOAD_0;
                    }
                    case 1: {
                        return OpCode.ILOAD_1;
                    }
                    case 2: {
                        return OpCode.ILOAD_2;
                    }
                    case 3: {
                        return OpCode.ILOAD_3;
                    }
                }
                return localIndex > 255 ? OpCode.ILOAD_W : OpCode.ILOAD;
            }
            case LONG: {
                switch (localIndex) {
                    case 0: {
                        return OpCode.LLOAD_0;
                    }
                    case 1: {
                        return OpCode.LLOAD_1;
                    }
                    case 2: {
                        return OpCode.LLOAD_2;
                    }
                    case 3: {
                        return OpCode.LLOAD_3;
                    }
                }
                return localIndex > 255 ? OpCode.LLOAD_W : OpCode.LLOAD;
            }
            case FLOAT: {
                switch (localIndex) {
                    case 0: {
                        return OpCode.FLOAD_0;
                    }
                    case 1: {
                        return OpCode.FLOAD_1;
                    }
                    case 2: {
                        return OpCode.FLOAD_2;
                    }
                    case 3: {
                        return OpCode.FLOAD_3;
                    }
                }
                return localIndex > 255 ? OpCode.FLOAD_W : OpCode.FLOAD;
            }
            case DOUBLE: {
                switch (localIndex) {
                    case 0: {
                        return OpCode.DLOAD_0;
                    }
                    case 1: {
                        return OpCode.DLOAD_1;
                    }
                    case 2: {
                        return OpCode.DLOAD_2;
                    }
                    case 3: {
                        return OpCode.DLOAD_3;
                    }
                }
                return localIndex > 255 ? OpCode.DLOAD_W : OpCode.DLOAD;
            }
        }
        switch (localIndex) {
            case 0: {
                return OpCode.ALOAD_0;
            }
            case 1: {
                return OpCode.ALOAD_1;
            }
            case 2: {
                return OpCode.ALOAD_2;
            }
            case 3: {
                return OpCode.ALOAD_3;
            }
        }
        return localIndex > 255 ? OpCode.ALOAD_W : OpCode.ALOAD;
    }

    private static OpCode getLocalStoreOpCode(Type<?> type, int localIndex) {
        switch (type.getKind()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case CHAR: {
                switch (localIndex) {
                    case 0: {
                        return OpCode.ISTORE_0;
                    }
                    case 1: {
                        return OpCode.ISTORE_1;
                    }
                    case 2: {
                        return OpCode.ISTORE_2;
                    }
                    case 3: {
                        return OpCode.ISTORE_3;
                    }
                }
                return OpCode.ISTORE;
            }
            case LONG: {
                switch (localIndex) {
                    case 0: {
                        return OpCode.LSTORE_0;
                    }
                    case 1: {
                        return OpCode.LSTORE_1;
                    }
                    case 2: {
                        return OpCode.LSTORE_2;
                    }
                    case 3: {
                        return OpCode.LSTORE_3;
                    }
                }
                return OpCode.LSTORE;
            }
            case FLOAT: {
                switch (localIndex) {
                    case 0: {
                        return OpCode.FSTORE_0;
                    }
                    case 1: {
                        return OpCode.FSTORE_1;
                    }
                    case 2: {
                        return OpCode.FSTORE_2;
                    }
                    case 3: {
                        return OpCode.FSTORE_3;
                    }
                }
                return OpCode.FSTORE;
            }
            case DOUBLE: {
                switch (localIndex) {
                    case 0: {
                        return OpCode.DSTORE_0;
                    }
                    case 1: {
                        return OpCode.DSTORE_1;
                    }
                    case 2: {
                        return OpCode.DSTORE_2;
                    }
                    case 3: {
                        return OpCode.DSTORE_3;
                    }
                }
                return OpCode.DSTORE;
            }
        }
        switch (localIndex) {
            case 0: {
                return OpCode.ASTORE_0;
            }
            case 1: {
                return OpCode.ASTORE_1;
            }
            case 2: {
                return OpCode.ASTORE_2;
            }
            case 3: {
                return OpCode.ASTORE_3;
            }
        }
        return OpCode.ASTORE;
    }

    final int translateParameter(int localIndex) {
        int index = localIndex;
        if (this.methodBuilder != null) {
            if (!this.methodBuilder.isStatic()) {
                ++index;
            }
            TypeList parameterTypes = this.methodBuilder.getParameterTypes();
            int n = parameterTypes.size();
            for (int i = 0; i < localIndex && i < n; ++i) {
                TypeKind kind = ((Type)parameterTypes.get(i)).getKind();
                if (kind != TypeKind.LONG && kind != TypeKind.DOUBLE) continue;
                ++index;
            }
        }
        return index;
    }

    final int translateLocal(int localIndex) {
        int index = 0;
        if (this.methodBuilder != null) {
            index += this.translateParameter(this.methodBuilder.parameterBuilders.length);
        }
        for (int i = 0; i < localIndex; ++i) {
            TypeKind kind = this.locals[i].getLocalType().getKind();
            index += kind == TypeKind.LONG || kind == TypeKind.DOUBLE ? 2 : 1;
        }
        return index;
    }

    public void emitLoadElement(Type<?> elementType) {
        VerifyArgument.notNull(elementType, "elementType");
        switch (elementType.getKind()) {
            case BOOLEAN: 
            case BYTE: {
                this.emit(OpCode.BALOAD);
                break;
            }
            case SHORT: {
                this.emit(OpCode.SALOAD);
                break;
            }
            case INT: {
                this.emit(OpCode.IALOAD);
                break;
            }
            case LONG: {
                this.emit(OpCode.LALOAD);
                break;
            }
            case CHAR: {
                this.emit(OpCode.CALOAD);
                break;
            }
            case FLOAT: {
                this.emit(OpCode.FALOAD);
                break;
            }
            case DOUBLE: {
                this.emit(OpCode.DALOAD);
                break;
            }
            case ARRAY: 
            case DECLARED: 
            case ERROR: 
            case TYPEVAR: 
            case WILDCARD: {
                this.emit(OpCode.AALOAD);
                break;
            }
            default: {
                throw Error.invalidType(elementType);
            }
        }
    }

    public void emitStoreElement(Type<?> elementType) {
        VerifyArgument.notNull(elementType, "elementType");
        switch (elementType.getKind()) {
            case BOOLEAN: 
            case BYTE: {
                this.emit(OpCode.BASTORE);
                break;
            }
            case SHORT: {
                this.emit(OpCode.SASTORE);
                break;
            }
            case INT: {
                this.emit(OpCode.IASTORE);
                break;
            }
            case LONG: {
                this.emit(OpCode.LASTORE);
                break;
            }
            case CHAR: {
                this.emit(OpCode.CASTORE);
                break;
            }
            case FLOAT: {
                this.emit(OpCode.FASTORE);
                break;
            }
            case DOUBLE: {
                this.emit(OpCode.DASTORE);
                break;
            }
            case ARRAY: 
            case DECLARED: 
            case ERROR: 
            case TYPEVAR: 
            case WILDCARD: {
                this.emit(OpCode.AASTORE);
                break;
            }
            default: {
                throw Error.invalidType(elementType);
            }
        }
    }

    public void getField(FieldInfo field) {
        VerifyArgument.notNull(field, "field");
        if (field.isStatic()) {
            this.emit(OpCode.GETSTATIC, field);
        } else {
            this.emit(OpCode.GETFIELD, field);
        }
    }

    public void putField(FieldInfo field) {
        VerifyArgument.notNull(field, "field");
        if (field.isStatic()) {
            this.emit(OpCode.PUTSTATIC, field);
        } else {
            this.emit(OpCode.PUTFIELD, field);
        }
    }

    public static boolean canEmitConstant(Object value, Type<?> type) {
        VerifyArgument.notNull(type, "type");
        return value == null || value instanceof Enum || value instanceof Type || value instanceof Class || value instanceof MethodBase || CodeGenerator.canEmitBytecodeConstant(type);
    }

    public void emitConstant(Object value) {
        if (value == null) {
            this.emitNull();
        } else {
            this.emitConstant(value, Type.getType(value));
        }
    }

    public void emitConstantArray(Object array) {
        VerifyArgument.notNull(array, "array");
        int length = Array.getLength(array);
        Type<Object> arrayType = Type.getType(array);
        Type<?> elementType = arrayType.getElementType();
        this.emitInteger(length);
        this.emitNewArray(arrayType);
        for (int i = 0; i < length; ++i) {
            this.dup();
            this.emitInteger(i);
            this.emitConstant(Array.get(array, i));
            this.emitStoreElement(elementType);
        }
    }

    public void emitConstant(Object value, Type<?> type) {
        if (value == null) {
            this.emitDefaultValue(type);
            return;
        }
        if (this.tryEmitConstant(value, type)) {
            return;
        }
        if (value instanceof Type) {
            this.emitType((Type)value);
            return;
        }
        if (value instanceof Class) {
            this.emitType(Type.of((Class)value));
            return;
        }
        if (value instanceof MethodBase) {
            this.emitMethod((MethodBase)value);
            return;
        }
        throw Error.valueMustBeConstant();
    }

    public void emitType(Type<?> value) {
        MethodBuilder methodBuilder = this.methodBuilder;
        if (methodBuilder == null) {
            throw Error.bytecodeGeneratorNotOwnedByMethodBuilder();
        }
        short typeToken = ((TypeBuilder)methodBuilder.getDeclaringType()).getTypeToken(value);
        this.emitLoadConstant(typeToken);
    }

    public void emitMethod(MethodBase value) {
        MethodBuilder methodBuilder = this.methodBuilder;
        if (methodBuilder == null) {
            throw Error.bytecodeGeneratorNotOwnedByMethodBuilder();
        }
        short methodToken = ((TypeBuilder)methodBuilder.getDeclaringType()).getMethodToken(value);
        this.emitLoadConstant(methodToken);
    }

    private boolean tryEmitConstant(Object value, Type<?> type) {
        Type<?> unboxedType = TypeUtils.getUnderlyingPrimitiveOrSelf(type);
        switch (unboxedType.getKind()) {
            case BOOLEAN: {
                this.emitBoolean((Boolean)value);
                return true;
            }
            case BYTE: {
                this.emitByte((Byte)value);
                return true;
            }
            case SHORT: {
                this.emitShort((Short)value);
                return true;
            }
            case INT: {
                this.emitInteger((Integer)value);
                return true;
            }
            case LONG: {
                this.emitLong((Long)value);
                return true;
            }
            case CHAR: {
                this.emitCharacter(((Character)value).charValue());
                return true;
            }
            case FLOAT: {
                this.emitFloat(((Float)value).floatValue());
                return true;
            }
            case DOUBLE: {
                this.emitDouble((Double)value);
                return true;
            }
        }
        if (unboxedType == Types.String) {
            this.emitString((String)value);
            return true;
        }
        if (unboxedType.isEnum()) {
            this.getField(unboxedType.getField(value.toString()));
            return true;
        }
        return false;
    }

    public void emitNull() {
        this.emit(OpCode.ACONST_NULL);
    }

    public void emitDefaultValue(Type<?> type) {
        VerifyArgument.notNull(type, "type");
        switch (type.getKind()) {
            case BOOLEAN: {
                this.emit(OpCode.ICONST_0);
                break;
            }
            case BYTE: {
                this.emit(OpCode.ICONST_0);
                this.emit(OpCode.I2B);
                break;
            }
            case SHORT: {
                this.emit(OpCode.ICONST_0);
                this.emit(OpCode.I2S);
                break;
            }
            case INT: {
                this.emit(OpCode.ICONST_0);
                break;
            }
            case LONG: {
                this.emit(OpCode.LCONST_0);
                break;
            }
            case CHAR: {
                this.emit(OpCode.ICONST_0);
                this.emit(OpCode.I2C);
                break;
            }
            case FLOAT: {
                this.emit(OpCode.FCONST_0);
                break;
            }
            case DOUBLE: {
                this.emit(OpCode.DCONST_0);
                break;
            }
            case ARRAY: 
            case DECLARED: 
            case ERROR: 
            case TYPEVAR: 
            case NULL: {
                this.emit(OpCode.ACONST_NULL);
                break;
            }
            case VOID: {
                this.emit(OpCode.NOP);
                break;
            }
            default: {
                throw Error.invalidType(type);
            }
        }
    }

    public void emitBoolean(boolean value) {
        this.emit(value ? OpCode.ICONST_1 : OpCode.ICONST_0);
    }

    public void emitByte(byte value) {
        this.emit(OpCode.BIPUSH, value);
    }

    public void emitCharacter(char value) {
        if (value <= '\u00ff') {
            this.emitByte((byte)value);
        } else {
            this.emitShort((short)value);
        }
    }

    public void emitShort(short value) {
        this.emit(OpCode.SIPUSH, value);
    }

    public void emitInteger(int value) {
        switch (value) {
            case -1: {
                this.emit(OpCode.ICONST_M1);
                return;
            }
            case 0: {
                this.emit(OpCode.ICONST_0);
                return;
            }
            case 1: {
                this.emit(OpCode.ICONST_1);
                return;
            }
            case 2: {
                this.emit(OpCode.ICONST_2);
                return;
            }
            case 3: {
                this.emit(OpCode.ICONST_3);
                return;
            }
            case 4: {
                this.emit(OpCode.ICONST_4);
                return;
            }
            case 5: {
                this.emit(OpCode.ICONST_5);
                return;
            }
        }
        MethodBuilder methodBuilder = this.methodBuilder;
        if (methodBuilder == null) {
            throw Error.bytecodeGeneratorNotOwnedByMethodBuilder();
        }
        short constantToken = ((TypeBuilder)methodBuilder.getDeclaringType()).getConstantToken(value);
        this.emitLoadConstant(constantToken);
    }

    public void emitLong(long value) {
        if (value == 0L) {
            this.emit(OpCode.LCONST_0);
            return;
        }
        if (value == 1L) {
            this.emit(OpCode.LCONST_1);
            return;
        }
        MethodBuilder methodBuilder = this.methodBuilder;
        if (methodBuilder == null) {
            throw Error.bytecodeGeneratorNotOwnedByMethodBuilder();
        }
        short constantToken = ((TypeBuilder)methodBuilder.getDeclaringType()).getConstantToken(value);
        this.emitLoadLongConstant(constantToken);
    }

    public void emitFloat(float value) {
        if (value == 0.0f) {
            this.emit(OpCode.FCONST_0);
            return;
        }
        if (value == 1.0f) {
            this.emit(OpCode.FCONST_1);
            return;
        }
        if (value == 2.0f) {
            this.emit(OpCode.FCONST_2);
            return;
        }
        MethodBuilder methodBuilder = this.methodBuilder;
        if (methodBuilder == null) {
            throw Error.bytecodeGeneratorNotOwnedByMethodBuilder();
        }
        short constantToken = ((TypeBuilder)methodBuilder.getDeclaringType()).getConstantToken(value);
        this.emitLoadConstant(constantToken);
    }

    public void emitDouble(double value) {
        if (value == 0.0) {
            this.emit(OpCode.DCONST_0);
            return;
        }
        if (value == 1.0) {
            this.emit(OpCode.DCONST_1);
            return;
        }
        MethodBuilder methodBuilder = this.methodBuilder;
        if (methodBuilder == null) {
            throw Error.bytecodeGeneratorNotOwnedByMethodBuilder();
        }
        short constantToken = ((TypeBuilder)methodBuilder.getDeclaringType()).getConstantToken(value);
        this.emitLoadLongConstant(constantToken);
    }

    public void emitString(String value) {
        if (value == null) {
            this.emitNull();
            return;
        }
        MethodBuilder methodBuilder = this.methodBuilder;
        if (methodBuilder == null) {
            throw Error.bytecodeGeneratorNotOwnedByMethodBuilder();
        }
        short stringToken = ((TypeBuilder)methodBuilder.getDeclaringType()).getStringToken(value);
        this.emitLoadConstant(stringToken);
    }

    protected void emitLoadConstant(int token) {
        if (token < 0 || token > 255) {
            this.emit(OpCode.LDC_W);
            this.emitShortOperand(token);
        } else {
            this.emit(OpCode.LDC);
            this.emitByteOperand(token);
        }
    }

    protected void emitLoadLongConstant(int token) {
        this.emit(OpCode.LDC2_W);
        this.emitShortOperand(token);
    }

    private static boolean canEmitBytecodeConstant(Type<?> type) {
        Type<?> unboxedType = TypeUtils.getUnderlyingPrimitiveOrSelf(type);
        switch (unboxedType.getKind()) {
            case LONG: 
            case DOUBLE: 
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case CHAR: 
            case FLOAT: {
                return true;
            }
        }
        return type.isEquivalentTo(Types.String);
    }

    public void emitBox(Type<?> type) {
        MethodInfo boxMethod = TypeUtils.getBoxMethod(VerifyArgument.notNull(type, "type"));
        if (boxMethod != null) {
            this.call(OpCode.INVOKESTATIC, boxMethod);
        }
    }

    public void emitUnbox(Type<?> type) {
        MethodInfo unboxMethod = TypeUtils.getUnboxMethod(VerifyArgument.notNull(type, "type"));
        if (unboxMethod != null) {
            this.call(OpCode.INVOKEVIRTUAL, unboxMethod);
        }
    }

    public void emitConversion(Type<?> sourceType, Type<?> targetType) {
        VerifyArgument.notNull(sourceType, "sourceType");
        VerifyArgument.notNull(targetType, "targetType");
        if (sourceType == targetType || sourceType.isEquivalentTo(targetType)) {
            return;
        }
        if (sourceType == PrimitiveTypes.Void || targetType == PrimitiveTypes.Void) {
            throw Error.cannotConvertToOrFromVoid();
        }
        boolean isTypeSourceBoxed = TypeUtils.isAutoUnboxed(sourceType);
        boolean isTypeTargetBoxed = TypeUtils.isAutoUnboxed(targetType);
        Type<?> unboxedSourceType = TypeUtils.getUnderlyingPrimitiveOrSelf(sourceType);
        Type<?> unboxedTargetType = TypeUtils.getUnderlyingPrimitiveOrSelf(targetType);
        if (sourceType.isInterface() || targetType.isInterface() || sourceType == Types.Object || targetType == Types.Object) {
            this.emitCastToType(sourceType, targetType);
        } else if (isTypeSourceBoxed || isTypeTargetBoxed) {
            this.emitBoxingConversion(sourceType, targetType);
        } else if (!(unboxedSourceType.isPrimitive() && unboxedTargetType.isPrimitive() || !unboxedSourceType.isAssignableFrom(unboxedTargetType) && !unboxedTargetType.isAssignableFrom(unboxedSourceType))) {
            this.emitCastToType(sourceType, targetType);
        } else if (sourceType.isArray() && targetType.isArray()) {
            this.emitCastToType(sourceType, targetType);
        } else {
            this.emitNumericConversion(sourceType, targetType);
        }
    }

    private void emitBoxingConversion(Type<?> sourceType, Type<?> targetType) {
        boolean isSourceTypeBoxed = TypeUtils.isAutoUnboxed(sourceType);
        boolean isTargetTypeBoxed = TypeUtils.isAutoUnboxed(targetType);
        assert (isSourceTypeBoxed || isTargetTypeBoxed) : "isSourceTypeBoxed || isTargetTypeBoxed";
        if (isSourceTypeBoxed && isTargetTypeBoxed) {
            this.emitBoxedToBoxedConversion(sourceType, targetType);
        } else if (isSourceTypeBoxed) {
            this.emitBoxedToUnboxedConversion(sourceType, targetType);
        } else {
            this.emitUnboxedToBoxedConversion(sourceType, targetType);
        }
    }

    private void emitUnboxedToBoxedConversion(Type<?> sourceType, Type<?> targetType) {
        assert (sourceType.isPrimitive() && TypeUtils.isAutoUnboxed(targetType)) : "sourceType.isPrimitive() && TypeUtils.isAutoUnboxed(targetType)";
        Type<?> unboxedTargetType = TypeUtils.getUnderlyingPrimitive(targetType);
        LocalBuilder targetLocal = this.declareLocal(targetType);
        this.emitConversion(sourceType, unboxedTargetType);
        this.emitBox(targetType);
    }

    private void emitBoxedToUnboxedConversion(Type<?> sourceType, Type<?> targetType) {
        assert (TypeUtils.isAutoUnboxed(sourceType) && targetType.isPrimitive()) : "TypeUtils.isAutoUnboxed(sourceType) && targetType.isPrimitive()";
        if (targetType.isPrimitive()) {
            this.emitBoxedToUnboxedNumericConversion(sourceType, targetType);
        } else {
            this.emitBoxedToReferenceConversion(sourceType);
        }
    }

    private void emitBoxedToReferenceConversion(Type<?> sourceType) {
        assert (TypeUtils.isAutoUnboxed(sourceType)) : "TypeUtils.isAutoUnboxed(sourceType)";
        this.emitBox(sourceType);
    }

    private void emitBoxedToUnboxedNumericConversion(Type<?> sourceType, Type<?> targetType) {
        assert (TypeUtils.isAutoUnboxed(sourceType) && !TypeUtils.isAutoUnboxed(targetType)) : "TypeUtils.isAutoUnboxed(sourceType) && !TypeUtils.isAutoUnboxed(targetType)";
        MethodInfo coercionMethod = TypeUtils.getCoercionMethod(sourceType, targetType);
        if (coercionMethod != null) {
            this.call(coercionMethod);
        } else {
            Type<?> unboxedSourceType = TypeUtils.getUnderlyingPrimitive(sourceType);
            this.emitUnbox(sourceType);
            this.emitConversion(unboxedSourceType, targetType);
        }
    }

    private void emitBoxedToBoxedConversion(Type<?> sourceType, Type<?> targetType) {
        assert (TypeUtils.isAutoUnboxed(sourceType) && TypeUtils.isAutoUnboxed(targetType)) : "TypeUtils.isAutoUnboxed(sourceType) && TypeUtils.isAutoUnboxed(targetType)";
        LocalBuilder sourceLocal = this.declareLocal(sourceType);
        LocalBuilder targetLocal = this.declareLocal(targetType);
        Type<?> unboxedSourceType = TypeUtils.getUnderlyingPrimitive(sourceType);
        Type<?> unboxedTargetType = TypeUtils.getUnderlyingPrimitive(targetType);
        Label ifNull = this.defineLabel();
        Label end = this.defineLabel();
        this.emitStore(sourceLocal);
        this.emitStore(targetLocal);
        this.emitLoad(sourceLocal);
        this.emit(OpCode.IFNULL, ifNull);
        this.emitLoad(sourceLocal);
        this.emitUnbox(sourceType);
        this.emitConversion(unboxedSourceType, unboxedTargetType);
        this.emitBox(targetType);
        this.emitStore(targetLocal);
        this.emitGoto(end);
        this.markLabel(ifNull);
        this.emitNull();
        this.emitStore(targetLocal);
        this.markLabel(end);
        this.emitLoad(targetLocal);
    }

    private void emitCastToType(Type<?> sourceType, Type<?> targetType) {
        if (!sourceType.isPrimitive() && targetType.isPrimitive()) {
            Type<?> boxedTargetType = TypeUtils.getBoxedType(targetType);
            if (!sourceType.isEquivalentTo(boxedTargetType)) {
                this.emitCastToType(sourceType, boxedTargetType);
            }
            this.emitUnbox(targetType);
        } else if (sourceType.isPrimitive() && !targetType.isPrimitive()) {
            Type<?> boxedSourceType = TypeUtils.getBoxedType(sourceType);
            this.emitBox(sourceType);
            if (!targetType.isAssignableFrom(boxedSourceType)) {
                this.emitCastToType(boxedSourceType, targetType);
            }
        } else if (!sourceType.isPrimitive() && !targetType.isPrimitive()) {
            if (targetType == Types.Object) {
                return;
            }
            this.emit(OpCode.CHECKCAST, targetType);
        } else {
            throw Error.invalidCast(sourceType, targetType);
        }
    }

    private void emitNumericConversion(Type<?> sourceType, Type<?> targetType) {
        TypeKind targetKind;
        TypeKind sourceKind = sourceType.getKind();
        if (sourceKind == (targetKind = targetType.getKind())) {
            return;
        }
        switch (targetKind) {
            case BOOLEAN: {
                throw Error.invalidCast(sourceType, targetType);
            }
            case BYTE: {
                switch (sourceKind) {
                    case SHORT: 
                    case INT: 
                    case CHAR: {
                        this.emit(OpCode.I2B);
                        return;
                    }
                    case LONG: {
                        this.emit(OpCode.L2I);
                        this.emit(OpCode.I2B);
                        return;
                    }
                    case FLOAT: {
                        this.emit(OpCode.F2I);
                        this.emit(OpCode.I2B);
                        return;
                    }
                    case DOUBLE: {
                        this.emit(OpCode.D2I);
                        this.emit(OpCode.I2B);
                        return;
                    }
                }
            }
            case SHORT: {
                switch (sourceKind) {
                    case BYTE: 
                    case INT: 
                    case CHAR: {
                        this.emit(OpCode.I2S);
                        return;
                    }
                    case LONG: {
                        this.emit(OpCode.L2I);
                        this.emit(OpCode.I2S);
                        return;
                    }
                    case FLOAT: {
                        this.emit(OpCode.F2I);
                        this.emit(OpCode.I2S);
                        return;
                    }
                    case DOUBLE: {
                        this.emit(OpCode.D2I);
                        this.emit(OpCode.I2S);
                        return;
                    }
                }
            }
            case INT: {
                switch (sourceKind) {
                    case BYTE: 
                    case SHORT: 
                    case CHAR: {
                        return;
                    }
                    case LONG: {
                        this.emit(OpCode.L2I);
                        return;
                    }
                    case FLOAT: {
                        this.emit(OpCode.F2I);
                        return;
                    }
                    case DOUBLE: {
                        this.emit(OpCode.D2I);
                        return;
                    }
                }
            }
            case LONG: {
                switch (sourceKind) {
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case CHAR: {
                        this.emit(OpCode.I2L);
                        return;
                    }
                    case FLOAT: {
                        this.emit(OpCode.F2L);
                        return;
                    }
                    case DOUBLE: {
                        this.emit(OpCode.D2L);
                        return;
                    }
                }
            }
            case CHAR: {
                switch (sourceKind) {
                    case BYTE: 
                    case SHORT: 
                    case INT: {
                        this.emit(OpCode.I2C);
                        return;
                    }
                    case LONG: {
                        this.emit(OpCode.L2I);
                        this.emit(OpCode.I2C);
                        return;
                    }
                    case FLOAT: {
                        this.emit(OpCode.F2I);
                        this.emit(OpCode.I2C);
                        return;
                    }
                    case DOUBLE: {
                        this.emit(OpCode.D2I);
                        this.emit(OpCode.I2C);
                        return;
                    }
                }
            }
            case FLOAT: {
                switch (sourceKind) {
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case CHAR: {
                        this.emit(OpCode.I2F);
                        return;
                    }
                    case LONG: {
                        this.emit(OpCode.L2F);
                        return;
                    }
                    case DOUBLE: {
                        this.emit(OpCode.D2F);
                        return;
                    }
                }
            }
            case DOUBLE: {
                switch (sourceKind) {
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case CHAR: {
                        this.emit(OpCode.I2D);
                        return;
                    }
                    case LONG: {
                        this.emit(OpCode.L2D);
                        return;
                    }
                    case FLOAT: {
                        this.emit(OpCode.F2D);
                        return;
                    }
                }
            }
        }
        throw Error.invalidCast(sourceType, targetType);
    }

    public void emitSwitch(int[] keys, SwitchCallback callback) {
        VerifyArgument.notNull(keys, "keys");
        float density = keys.length == 0 ? 0.0f : (float)keys.length / (float)(keys[keys.length - 1] - keys[0] + 1);
        this.emitSwitch(keys, callback, density >= 0.5f ? SwitchOptions.PreferTable : SwitchOptions.PreferLookup);
    }

    public void emitSwitch(int[] keys, SwitchCallback callback, SwitchOptions options) {
        VerifyArgument.notNull(keys, "keys");
        VerifyArgument.notNull(callback, "callback");
        VerifyArgument.notNull(options, "options");
        Label breakTarget = this.defineLabel();
        Label defaultLabel = this.defineLabel();
        int start = this.offset();
        SwitchOptions resolvedOptions = CodeGenerator.resolveSwitchOptions(keys, options);
        try {
            if (keys.length > 0) {
                int length = keys.length;
                int minimum = keys[0];
                int maximum = keys[length - 1];
                int range = maximum - minimum + 1;
                if (resolvedOptions == SwitchOptions.PreferTable && range >= 0) {
                    Object[] labels = new Label[range];
                    Arrays.fill(labels, defaultLabel);
                    for (int key : keys) {
                        labels[key - minimum] = this.defineLabel();
                    }
                    this.emit(OpCode.TABLESWITCH);
                    int padding = (4 - this.offset() % 4) % 4;
                    for (int i = 0; i < padding; ++i) {
                        this.emitByteOperand(0);
                    }
                    this.addFixup(defaultLabel, start, this.offset(), 4);
                    this.emitIntOperand(0);
                    this.emitIntOperand(minimum);
                    this.emitIntOperand(maximum);
                    for (Object label : labels) {
                        this.addFixup((Label)label, start, this.offset(), 4);
                        this.emitIntOperand(0);
                    }
                    for (int i = 0; i < range; ++i) {
                        Object label = labels[i];
                        if (label == defaultLabel) continue;
                        this.markLabel((Label)label);
                        callback.emitCase(i + minimum, breakTarget);
                    }
                } else {
                    int i;
                    Label[] labels = new Label[length];
                    for (i = 0; i < length; ++i) {
                        labels[i] = this.defineLabel();
                    }
                    this.emit(OpCode.LOOKUPSWITCH);
                    int padding = (4 - this.offset() % 4) % 4;
                    for (i = 0; i < padding; ++i) {
                        this.emitByteOperand(0);
                    }
                    this.addFixup(defaultLabel, start, this.offset(), 4);
                    this.emitIntOperand(0);
                    this.emitIntOperand(length);
                    for (i = 0; i < length; ++i) {
                        this.emitIntOperand(keys[i]);
                        this.addFixup(labels[i], start, this.offset(), 4);
                        this.emitIntOperand(0);
                    }
                    for (i = 0; i < length; ++i) {
                        this.markLabel(labels[i]);
                        callback.emitCase(keys[i], breakTarget);
                    }
                }
            }
            this.markLabel(defaultLabel);
            callback.emitDefault(breakTarget);
            this.markLabel(breakTarget);
        }
        catch (Exception e) {
            throw Error.codeGenerationException(e);
        }
    }

    private static SwitchOptions resolveSwitchOptions(int[] keys, SwitchOptions options) {
        if (options == SwitchOptions.Default || options == null) {
            if (keys.length > 0 && (float)keys.length / (float)(keys[keys.length - 1] - keys[0] + 1) >= 0.5f) {
                return SwitchOptions.PreferTable;
            }
            return SwitchOptions.PreferLookup;
        }
        return options;
    }

    public <E extends Enum<E>> void emitSwitch(E[] keys, EnumSwitchCallback<E> callback) {
        this.emitSwitch((Enum[])keys, callback, SwitchOptions.Default);
    }

    public <E extends Enum<E>> void emitSwitch(E[] keys, final EnumSwitchCallback<E> callback, SwitchOptions options) {
        VerifyArgument.noNullElements(keys, "keys");
        VerifyArgument.notNull(callback, "callback");
        VerifyArgument.notNull(options, "options");
        final int[] intKeys = new int[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            intKeys[i] = ((Enum)keys[i]).ordinal();
        }
        this.emitSwitch(intKeys, new SwitchCallback((Enum[])keys){
            final /* synthetic */ Enum[] val$keys;
            {
                this.val$keys = enumArray;
            }

            @Override
            public void emitCase(int key, Label breakTarget) throws Exception {
                int keyIndex = ArrayUtilities.indexOf(intKeys, key);
                callback.emitCase(this.val$keys[keyIndex], breakTarget);
            }

            @Override
            public void emitDefault(Label breakTarget) throws Exception {
                callback.emitDefault(breakTarget);
            }
        }, options);
    }

    public void emitSwitch(String[] keys, StringSwitchCallback callback) {
        this.emitSwitch(keys, callback, SwitchOptions.Default);
    }

    public void emitSwitch(String[] keys, StringSwitchCallback callback, SwitchOptions options) {
        try {
            if (options == SwitchOptions.PreferTrie) {
                this.emitStringTrieSwitch(keys, callback);
            } else {
                this.emitStringHashSwitch(keys, callback, options != null ? options : SwitchOptions.Default);
            }
        }
        catch (Exception e) {
            throw Error.codeGenerationException(e);
        }
    }

    private static Map<Integer, List<String>> getStringSwitchBuckets(List<String> strings, Func1<String, Integer> keyCallback) {
        HashMap<Integer, List<String>> buckets = new HashMap<Integer, List<String>>();
        for (String s : strings) {
            Integer key = keyCallback.apply(s);
            LinkedList<String> bucket = (LinkedList<String>)buckets.get(key);
            if (bucket == null) {
                bucket = new LinkedList<String>();
                buckets.put(key, bucket);
            }
            bucket.add(s);
        }
        return buckets;
    }

    private void emitStringTrieSwitch(String[] keys, final StringSwitchCallback callback) throws Exception {
        final Label defaultLabel = this.defineLabel();
        final Label breakTarget = this.defineLabel();
        final Map<Integer, List<String>> buckets = CodeGenerator.getStringSwitchBuckets(Arrays.asList(keys), new Func1<String, Integer>(){

            @Override
            public Integer apply(String s) {
                return s.length();
            }
        });
        int i = 0;
        int[] intKeys = new int[buckets.size()];
        for (Integer key : buckets.keySet()) {
            intKeys[i++] = key;
        }
        Arrays.sort(intKeys);
        this.dup();
        this.call(StringLengthMethod);
        this.emitSwitch(intKeys, new SwitchCallback(){

            @Override
            public void emitCase(int key, Label ignore) throws Exception {
                List bucket = (List)buckets.get(key);
                CodeGenerator.this.stringSwitchHelper(bucket, callback, defaultLabel, breakTarget, 0);
            }

            @Override
            public void emitDefault(Label breakTarget2) throws Exception {
                CodeGenerator.this.emitGoto(defaultLabel);
            }
        });
        this.markLabel(defaultLabel);
        this.pop();
        callback.emitDefault(breakTarget);
        this.markLabel(breakTarget);
    }

    private void stringSwitchHelper(List<String> bucket, final StringSwitchCallback callback, final Label defaultLabel, final Label breakTarget, final int index) throws Exception {
        final int length = bucket.get(0).length();
        final Map<Integer, List<String>> buckets = CodeGenerator.getStringSwitchBuckets(bucket, new Func1<String, Integer>(){

            @Override
            public Integer apply(String s) {
                return s.charAt(index);
            }
        });
        this.dup();
        this.emitInteger(index);
        this.call(StringCharAtMethod);
        int i = 0;
        int[] intKeys = new int[buckets.size()];
        for (Integer key : buckets.keySet()) {
            intKeys[i++] = key;
        }
        Arrays.sort(intKeys);
        this.emitSwitch(intKeys, new SwitchCallback(){

            @Override
            public void emitCase(int key, Label ignore) throws Exception {
                List bucket = (List)buckets.get(key);
                if (index + 1 == length) {
                    CodeGenerator.this.pop();
                    callback.emitCase((String)bucket.get(0), breakTarget);
                } else {
                    CodeGenerator.this.stringSwitchHelper(bucket, callback, defaultLabel, breakTarget, index + 1);
                }
            }

            @Override
            public void emitDefault(Label breakTarget2) throws Exception {
                CodeGenerator.this.emitGoto(defaultLabel);
            }
        });
    }

    private void emitStringHashSwitch(String[] keys, final StringSwitchCallback callback, SwitchOptions options) throws Exception {
        final Map<Integer, List<String>> buckets = CodeGenerator.getStringSwitchBuckets(Arrays.asList(keys), new Func1<String, Integer>(){

            @Override
            public Integer apply(String s) {
                return s.hashCode();
            }
        });
        final Label defaultLabel = this.defineLabel();
        final Label breakTarget = this.defineLabel();
        this.dup();
        this.call(ObjectHashCodeMethod);
        int i = 0;
        int[] intKeys = new int[buckets.size()];
        for (Integer key : buckets.keySet()) {
            intKeys[i++] = key;
        }
        Arrays.sort(intKeys);
        this.emitSwitch(intKeys, new SwitchCallback(){

            @Override
            public void emitCase(int key, Label ignore) throws Exception {
                List bucket = (List)buckets.get(key);
                Label next = null;
                Iterator it = bucket.iterator();
                while (it.hasNext()) {
                    String string = (String)it.next();
                    if (next != null) {
                        CodeGenerator.this.markLabel(next);
                    }
                    if (it.hasNext()) {
                        CodeGenerator.this.dup();
                    }
                    CodeGenerator.this.emitString(string);
                    CodeGenerator.this.call(ObjectEqualsMethod);
                    if (it.hasNext()) {
                        next = CodeGenerator.this.defineLabel();
                        CodeGenerator.this.emit(OpCode.IFEQ, next);
                        CodeGenerator.this.pop();
                    } else {
                        CodeGenerator.this.emit(OpCode.IFEQ, defaultLabel);
                    }
                    callback.emitCase(string, breakTarget);
                }
            }

            @Override
            public void emitDefault(Label breakTarget2) throws Exception {
                CodeGenerator.this.pop();
            }
        }, options);
        this.markLabel(defaultLabel);
        callback.emitDefault(breakTarget);
        this.markLabel(breakTarget);
    }

    final void emitByteOperand(int value) {
        this._codeStream.putByte(value);
    }

    final void emitCharOperand(char value) {
        this._codeStream.putShort(value);
    }

    final void emitShortOperand(int value) {
        this._codeStream.putShort(value);
    }

    final void emitIntOperand(int value) {
        this._codeStream.putInt(value);
    }

    final void emitLongOperand(long value) {
        this._codeStream.putLong(value);
    }

    final void emitFloatOperand(float value) {
        this.emitIntOperand(Float.floatToIntBits(value));
    }

    final void emitDoubleOperand(double value) {
        this.emitLongOperand(Double.doubleToRawLongBits(value));
    }

    void internalEmit(OpCode opCode) {
        if (opCode.getSize() == 1) {
            this._codeStream.putByte((byte)(opCode.getCode() & 0xFF));
        } else {
            this._codeStream.putByte((byte)(opCode.getCode() >> 8 & 0xFF));
            this._codeStream.putByte((byte)(opCode.getCode() >> 0 & 0xFF));
        }
        this.updateStackSize(opCode, opCode.getStackChange());
    }

    static byte getByteOperand(byte[] codes, int index) {
        return codes[index];
    }

    static char getCharOperand(byte[] codes, int index) {
        int hi = (codes[index + 0] & 0xFF) << 8;
        int lo = (codes[index + 1] & 0xFF) << 0;
        return (char)(hi + lo);
    }

    static short getShortOperand(byte[] codes, int index) {
        int hi = (codes[index + 0] & 0xFF) << 8;
        int lo = (codes[index + 1] & 0xFF) << 0;
        return (short)(hi + lo);
    }

    static int getIntOperand(byte[] codes, int index) {
        int hh = (codes[index + 0] & 0xFF) << 24;
        int hl = (codes[index + 1] & 0xFF) << 16;
        int lh = (codes[index + 2] & 0xFF) << 8;
        int ll = (codes[index + 3] & 0xFF) << 0;
        return hh + hl + lh + ll;
    }

    static long getLongOperand(byte[] codes, int index) {
        return ((long)CodeGenerator.getIntOperand(codes, index) << 32) + ((long)CodeGenerator.getIntOperand(codes, index) << 0);
    }

    static float getFloatOperand(byte[] codes, int index) {
        return Float.intBitsToFloat(CodeGenerator.getIntOperand(codes, index));
    }

    static double getDoubleOperand(byte[] codes, int index) {
        return Double.longBitsToDouble(CodeGenerator.getIntOperand(codes, index));
    }

    static void putByteOperand(byte[] codes, int index, byte value) {
        codes[index] = value;
    }

    static void putCharOperand(byte[] codes, int index, char value) {
        codes[index + 0] = (byte)(value >> 8 & 0xFF);
        codes[index + 1] = (byte)(value >> 0 & 0xFF);
    }

    static void putShortOperand(byte[] codes, int index, short value) {
        codes[index + 0] = (byte)(value >> 8 & 0xFF);
        codes[index + 1] = (byte)(value >> 0 & 0xFF);
    }

    static void putIntOperand(byte[] codes, int index, int value) {
        codes[index + 0] = (byte)(value >> 24 & 0xFF);
        codes[index + 1] = (byte)(value >> 16 & 0xFF);
        codes[index + 2] = (byte)(value >> 8 & 0xFF);
        codes[index + 3] = (byte)(value >> 0 & 0xFF);
    }

    static void putLongOperand(byte[] codes, int index, long value) {
        codes[index + 0] = (byte)(value >> 56 & 0xFFL);
        codes[index + 1] = (byte)(value >> 48 & 0xFFL);
        codes[index + 2] = (byte)(value >> 40 & 0xFFL);
        codes[index + 3] = (byte)(value >> 32 & 0xFFL);
        codes[index + 4] = (byte)(value >> 24 & 0xFFL);
        codes[index + 5] = (byte)(value >> 16 & 0xFFL);
        codes[index + 6] = (byte)(value >> 8 & 0xFFL);
        codes[index + 7] = (byte)(value >> 0 & 0xFFL);
    }

    static void putFloatOperand(byte[] codes, int index, float value) {
        CodeGenerator.putIntOperand(codes, index, Float.floatToRawIntBits(value));
    }

    static void putDoubleOperand(byte[] codes, int index, double value) {
        CodeGenerator.putLongOperand(codes, index, Double.doubleToRawLongBits(value));
    }

    private void addFixup(Label label, int offsetOrigin, int fixupPosition, int operandSize) {
        if (this._fixupData == null) {
            this._fixupData = new __FixupData[64];
        }
        if (this._fixupCount >= this._fixupData.length) {
            this._fixupData = CodeGenerator.enlargeArray(this._fixupData);
        }
        if (this._fixupData[this._fixupCount] == null) {
            this._fixupData[this._fixupCount] = new __FixupData();
        }
        this._fixupData[this._fixupCount].offsetOrigin = offsetOrigin;
        this._fixupData[this._fixupCount].fixupPosition = fixupPosition;
        this._fixupData[this._fixupCount].fixupLabel = label;
        this._fixupData[this._fixupCount].operandSize = operandSize;
        ++this._fixupCount;
    }

    final void ensureCapacity(int size) {
        this._codeStream.ensureCapacity(size);
    }

    final void updateStackSize(OpCode opCode, int stackChange) {
        this._maxMidStackCur += stackChange;
        if (this._maxMidStackCur > this._maxMidStack) {
            this._maxMidStack = this._maxMidStackCur;
        } else if (this._maxMidStackCur < 0) {
            this._maxMidStackCur = 0;
        }
        if (opCode.endsUnconditionalJumpBlock()) {
            this._maxStackSize += this._maxMidStack;
            this._maxMidStack = 0;
            this._maxMidStackCur = 0;
        }
    }

    private int getLabelPosition(Label label) {
        int index = label.getLabelValue();
        if (index < 0 || index >= this._labelCount) {
            throw Error.badLabel();
        }
        if (this._labelList[index] < 0) {
            throw Error.badLabelContent();
        }
        return this._labelList[index];
    }

    final byte[] bakeByteArray() {
        if (this._currentExceptionStackCount != 0) {
            throw Error.unclosedExceptionBlock();
        }
        if (this._codeStream.getLength() == 0) {
            return null;
        }
        int newSize = this._codeStream.getLength();
        byte[] newBytes = Arrays.copyOf(this._codeStream.getData(), newSize);
        for (int i = 0; i < this._fixupCount; ++i) {
            int fixupPosition = this._fixupData[i].fixupPosition;
            int updateAddress = this.getLabelPosition(this._fixupData[i].fixupLabel) - this._fixupData[i].offsetOrigin;
            if (this._fixupData[i].operandSize == 2) {
                if (updateAddress < Short.MIN_VALUE || updateAddress > Short.MAX_VALUE) {
                    throw Error.branchAddressTooLarge();
                }
                CodeGenerator.putShortOperand(newBytes, fixupPosition, (short)updateAddress);
                continue;
            }
            CodeGenerator.putIntOperand(newBytes, fixupPosition, updateAddress);
        }
        return newBytes;
    }

    static int[] enlargeArray(int[] incoming) {
        return Arrays.copyOf(VerifyArgument.notNull(incoming, "incoming"), incoming.length * 2);
    }

    static <T> T[] enlargeArray(T[] incoming) {
        return Arrays.copyOf(incoming, incoming.length * 2);
    }

    static byte[] enlargeArray(byte[] incoming) {
        return Arrays.copyOf(VerifyArgument.notNull(incoming, "incoming"), incoming.length * 2);
    }

    static byte[] enlargeArray(byte[] incoming, int requiredSize) {
        return Arrays.copyOf(VerifyArgument.notNull(incoming, "incoming"), requiredSize);
    }

    final __ExceptionInfo[] getExceptions() {
        if (this._currentExceptionStackCount != 0) {
            throw Error.unclosedExceptionBlock();
        }
        if (this._exceptionCount == 0) {
            return null;
        }
        __ExceptionInfo[] temp = Arrays.copyOf(this._exceptions, this._exceptionCount);
        CodeGenerator.sortExceptions(temp);
        return temp;
    }

    final Type<?>[] getUnhandledCheckedExceptions() {
        if (this._unhandledExceptionCount == 0) {
            return Type.EmptyTypes;
        }
        return Arrays.copyOf(this._unhandledExceptions, this._unhandledExceptionCount);
    }

    final int getMaxStackSize() {
        return this._maxStackSize;
    }

    private static void sortExceptions(__ExceptionInfo[] exceptions) {
        int length = exceptions.length;
        for (int i = 0; i < length; ++i) {
            int least = i;
            for (int j = i + 1; j < length; ++j) {
                if (!exceptions[least].isInner(exceptions[j])) continue;
                least = j;
            }
            __ExceptionInfo temp = exceptions[i];
            exceptions[i] = exceptions[least];
            exceptions[least] = temp;
        }
    }

    private void registerCheckedExceptions(MethodBase method) {
        TypeList thrownTypes = method.getThrownTypes();
        if (thrownTypes == null || thrownTypes.isEmpty()) {
            return;
        }
        int n = thrownTypes.size();
        for (int i = 0; i < n; ++i) {
            int j;
            Type thrownType = (Type)thrownTypes.get(i);
            if (Types.RuntimeException.isAssignableFrom(thrownType)) continue;
            for (j = 0; j < this._currentExceptionStackCount; ++j) {
                __ExceptionInfo exceptionInfo = this._currentExceptionStack[j];
                for (Type caughtType : exceptionInfo._catchClass) {
                    if (caughtType == null) break;
                    if (!caughtType.isAssignableFrom(thrownType)) continue;
                    return;
                }
            }
            if (this._unhandledExceptions == null) {
                this._unhandledExceptions = new Type[8];
                this._unhandledExceptions[this._unhandledExceptionCount++] = thrownType;
                return;
            }
            for (j = 0; j < this._unhandledExceptionCount; ++j) {
                Type<?> e = this._unhandledExceptions[j];
                if (thrownType.isSubTypeOf(e)) {
                    return;
                }
                if (!e.isSubTypeOf(thrownType)) continue;
                this._unhandledExceptions[j] = thrownType;
                return;
            }
            this._unhandledExceptions[this._unhandledExceptionCount++] = thrownType;
        }
    }

    public static interface EmitArrayElementCallback {
        public void emit(int var1);
    }
}

