/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.cyclelog.outputs.logger;

import io.engineblock.activityapi.cyclelog.buffers.results.ResultReadable;
import io.engineblock.activityapi.cyclelog.inputs.cyclelog.CanFilterResultValue;
import io.engineblock.activityapi.output.Output;
import io.engineblock.activityimpl.ActivityDef;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingOutput
implements Output,
CanFilterResultValue {
    private static final Logger logger = LoggerFactory.getLogger(LoggingOutput.class);
    private final ActivityDef def;
    private final long slot;
    private final ThreadLocal<StringBuilder> sb = ThreadLocal.withInitial(StringBuilder::new);
    private Predicate<ResultReadable> filter;

    public LoggingOutput(ActivityDef def, long slot) {
        this.def = def;
        this.slot = slot;
    }

    @Override
    public boolean onCycleResult(long completedCycle, int result) {
        if (this.filter != null && !this.filter.test(new ResultReadableWrapper(result))) {
            return true;
        }
        this.sb.get().setLength(0);
        this.sb.get().append("activity=").append(this.def.getAlias()).append(",cycle=").append(completedCycle).append(",result=").append((byte)(result & 0x7F));
        logger.info(this.sb.get().toString());
        return true;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void setFilter(Predicate<ResultReadable> filter) {
        this.filter = filter;
    }

    private static class ResultReadableWrapper
    implements ResultReadable {
        private int result;

        public ResultReadableWrapper(int result) {
            this.result = result;
        }

        @Override
        public int getResult() {
            return this.result;
        }
    }
}

