/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityimpl.motor;

import com.codahale.metrics.Timer;
import com.google.shaded.common.util.concurrent.RateLimiter;
import io.engineblock.activityapi.core.Action;
import io.engineblock.activityapi.core.ActivityDefObserver;
import io.engineblock.activityapi.core.Motor;
import io.engineblock.activityapi.core.MultiPhaseAction;
import io.engineblock.activityapi.core.RunState;
import io.engineblock.activityapi.core.Stoppable;
import io.engineblock.activityapi.cyclelog.buffers.cycles.CycleSegment;
import io.engineblock.activityapi.cyclelog.buffers.results.CycleResultSegmentBuffer;
import io.engineblock.activityapi.cyclelog.buffers.results.CycleResultsSegment;
import io.engineblock.activityapi.input.Input;
import io.engineblock.activityapi.input.RateLimiterProvider;
import io.engineblock.activityapi.output.Output;
import io.engineblock.activityimpl.ActivityDef;
import io.engineblock.activityimpl.SlotStateTracker;
import io.engineblock.metrics.ActivityMetrics;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreMotor
implements ActivityDefObserver,
Motor,
Stoppable {
    private static final Logger logger = LoggerFactory.getLogger(CoreMotor.class);
    private long slotId;
    private Input input;
    private Action action;
    private ActivityDef activityDef;
    private SlotStateTracker slotStateTracker;
    private AtomicReference<RunState> slotState;
    private RateLimiter rateLimiter;
    private int stride = 1;
    private Output output;

    public CoreMotor(ActivityDef activityDef, long slotId, Input input) {
        this.activityDef = activityDef;
        this.slotId = slotId;
        this.setInput(input);
        this.slotStateTracker = new SlotStateTracker(slotId);
        this.slotState = this.slotStateTracker.getAtomicSlotState();
        this.onActivityDefUpdate(activityDef);
    }

    public CoreMotor(ActivityDef activityDef, long slotId, Input input, Action action) {
        this(activityDef, slotId, input);
        this.setAction(action);
    }

    public CoreMotor(ActivityDef activityDef, long slotId, Input input, Action action, Output output) {
        this(activityDef, slotId, input);
        this.setAction(action);
        this.setResultOutput(output);
    }

    @Override
    public Motor setInput(Input input) {
        this.input = input;
        return this;
    }

    @Override
    public Input getInput() {
        return this.input;
    }

    @Override
    public Motor setAction(Action action) {
        this.action = action;
        return this;
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    @Override
    public long getSlotId() {
        return this.slotId;
    }

    @Override
    public SlotStateTracker getSlotStateTracker() {
        return this.slotStateTracker;
    }

    @Override
    public void run() {
        try {
            Timer cyclesTimer = ActivityMetrics.timer(this.activityDef, "cycles");
            Timer phasesTimer = ActivityMetrics.timer(this.activityDef, "phases");
            Timer stridesTimer = ActivityMetrics.timer(this.activityDef, "strides");
            Timer inputTimer = ActivityMetrics.timer(this.activityDef, "read-input");
            if (this.slotState.get() == RunState.Finished) {
                logger.warn("Input was already exhausted for slot " + this.slotId + ", remaining in finished state.");
            }
            this.slotStateTracker.enterState(RunState.Running);
            MultiPhaseAction multiPhaseAction = null;
            if (this.action instanceof MultiPhaseAction) {
                multiPhaseAction = (MultiPhaseAction)this.action;
            }
            this.action.init();
            while (this.slotState.get() == RunState.Running) {
                CycleSegment cycleSegment = null;
                try (Timer.Context inputTime = inputTimer.time();){
                    cycleSegment = this.input.getInputSegment(this.stride);
                }
                if (cycleSegment == null) {
                    logger.trace("input exhausted (input " + this.input + ") via null segment, stopping motor thread " + this.slotId);
                    this.slotStateTracker.enterState(RunState.Finished);
                    continue;
                }
                CycleResultSegmentBuffer segBuffer = new CycleResultSegmentBuffer(this.stride);
                try (Timer.Context stridesTime = stridesTimer.time();){
                    while (!cycleSegment.isExhausted()) {
                        int result;
                        long cyclenum;
                        block74: {
                            cyclenum = cycleSegment.nextCycle();
                            if (cyclenum < 0L && cycleSegment.isExhausted()) {
                                logger.trace("input exhausted (input " + this.input + ") via negative read, stopping motor thread " + this.slotId);
                                this.slotStateTracker.enterState(RunState.Finished);
                                continue;
                            }
                            if (this.slotState.get() != RunState.Running) {
                                logger.trace("motor stopped after input (input " + cyclenum + "), stopping motor thread " + this.slotId);
                                continue;
                            }
                            result = -1;
                            try (Timer.Context cycleTime = cyclesTimer.time();){
                                try (Timer.Context phaseTime = phasesTimer.time();){
                                    result = this.action.runCycle(cyclenum);
                                }
                                if (multiPhaseAction == null) break block74;
                                while (multiPhaseAction.incomplete()) {
                                    if (this.rateLimiter != null) {
                                        this.rateLimiter.acquire();
                                    }
                                    phaseTime = phasesTimer.time();
                                    var16_25 = null;
                                    try {
                                        result = multiPhaseAction.runPhase(cyclenum);
                                    }
                                    catch (Throwable throwable) {
                                        var16_25 = throwable;
                                        throw throwable;
                                    }
                                    finally {
                                        if (phaseTime == null) continue;
                                        if (var16_25 != null) {
                                            try {
                                                phaseTime.close();
                                            }
                                            catch (Throwable throwable) {
                                                var16_25.addSuppressed(throwable);
                                            }
                                            continue;
                                        }
                                        phaseTime.close();
                                    }
                                }
                            }
                        }
                        segBuffer.append(cyclenum, result);
                    }
                }
                if (this.output == null) continue;
                CycleResultsSegment outputBuffer = segBuffer.toReader();
                try {
                    this.output.onCycleResultSegment(outputBuffer);
                }
                catch (Exception t) {
                    logger.error("Error while feeding result segment " + outputBuffer + " to output '" + this.output + "', error:" + t);
                    throw t;
                }
            }
            if (this.slotState.get() == RunState.Stopping) {
                this.slotStateTracker.enterState(RunState.Stopped);
            }
        }
        catch (Throwable t) {
            logger.error("Error in core motor loop:" + t, t);
            throw t;
        }
    }

    public String toString() {
        return "slot:" + this.slotId + "; state:" + (Object)((Object)this.slotState.get());
    }

    @Override
    public void onActivityDefUpdate(ActivityDef activityDef) {
        for (Object component : new Object[]{this.input, this.action, this.output}) {
            if (component == null || !(component instanceof ActivityDefObserver)) continue;
            ((ActivityDefObserver)component).onActivityDefUpdate(activityDef);
        }
        this.rateLimiter = this.input instanceof RateLimiterProvider ? ((RateLimiterProvider)((Object)this.input)).getRateLimiter() : null;
        this.stride = activityDef.getParams().getOptionalInteger("stride").orElse(1);
    }

    @Override
    public synchronized void requestStop() {
        if (this.slotState.get() == RunState.Running) {
            if (this.input instanceof Stoppable) {
                ((Stoppable)((Object)this.input)).requestStop();
            }
            if (this.action instanceof Stoppable) {
                ((Stoppable)((Object)this.action)).requestStop();
            }
            this.slotStateTracker.enterState(RunState.Stopping);
        } else if (this.slotState.get() != RunState.Stopped && this.slotState.get() != RunState.Stopping) {
            logger.warn("attempted to stop motor " + this.getSlotId() + ": from non Running state:" + (Object)((Object)this.slotState.get()));
        }
    }

    public void setResultOutput(Output resultOutput) {
        this.output = resultOutput;
    }
}

