/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.extensions.csvmetrics;

import com.codahale.metrics.MetricRegistry;
import io.engineblock.extensions.csvmetrics.CSVMetrics;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.script.ScriptContext;
import org.slf4j.Logger;

public class CSVMetricsPlugin {
    private final ScriptContext context;
    private final Logger logger;
    private final MetricRegistry metricRegistry;

    public CSVMetricsPlugin(Logger logger, MetricRegistry metricRegistry, ScriptContext scriptContext) {
        this.logger = logger;
        this.metricRegistry = metricRegistry;
        this.context = scriptContext;
    }

    public CSVMetrics log(String filename) {
        CSVMetrics csvMetrics = new CSVMetrics(filename, this.logger, this.metricRegistry);
        this.writeStdout("started new csvlogger: " + filename);
        return csvMetrics;
    }

    public CSVMetrics log(String filename, long period, String timeUnit) {
        TimeUnit mappedTimeUnit = TimeUnit.valueOf(timeUnit);
        CSVMetrics csvMetrics = new CSVMetrics(filename, this.logger, this.metricRegistry, period, mappedTimeUnit);
        this.writeStdout("started new csvlogger: " + filename);
        return csvMetrics;
    }

    private void writeStdout(String msg) {
        try {
            this.context.getWriter().write(msg);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

