/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.metrics;

import com.codahale.metrics.Timer;
import io.engineblock.metrics.ConvenientSnapshot;
import io.engineblock.metrics.DeltaHdrHistogramReservoir;
import io.engineblock.metrics.DeltaSnapshotReader;
import io.engineblock.metrics.DeltaSnapshotter;
import io.engineblock.metrics.HdrDeltaHistogramAttachment;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.HdrHistogram.Histogram;

public class NicerTimer
extends Timer
implements DeltaSnapshotter,
HdrDeltaHistogramAttachment {
    private final String metricName;
    private DeltaHdrHistogramReservoir deltaHdrHistogramReservoir;
    private long cacheExpiry = 0L;
    private ConvenientSnapshot lastSnapshot;
    private List<NicerTimer> mirrors;

    public NicerTimer(String metricName, DeltaHdrHistogramReservoir deltaHdrHistogramReservoir) {
        super(deltaHdrHistogramReservoir);
        this.metricName = metricName;
        this.deltaHdrHistogramReservoir = deltaHdrHistogramReservoir;
    }

    @Override
    public ConvenientSnapshot getSnapshot() {
        if (System.currentTimeMillis() >= this.cacheExpiry) {
            return new ConvenientSnapshot(this.deltaHdrHistogramReservoir.getSnapshot());
        }
        return new ConvenientSnapshot(this.deltaHdrHistogramReservoir.getLastSnapshot());
    }

    @Override
    public DeltaSnapshotReader getDeltaReader() {
        return new DeltaSnapshotReader(this);
    }

    @Override
    public ConvenientSnapshot getDeltaSnapshot(long cacheTimeMillis) {
        this.cacheExpiry = System.currentTimeMillis() + cacheTimeMillis;
        return new ConvenientSnapshot(this.deltaHdrHistogramReservoir.getSnapshot());
    }

    @Override
    public synchronized NicerTimer attach() {
        DeltaHdrHistogramReservoir sameConfigReservoir = this.deltaHdrHistogramReservoir.copySettings();
        NicerTimer mirror = new NicerTimer(this.metricName, sameConfigReservoir);
        if (this.mirrors == null) {
            this.mirrors = new CopyOnWriteArrayList<NicerTimer>();
        }
        this.mirrors.add(mirror);
        return mirror;
    }

    @Override
    public Histogram getNextHdrDeltaHistogram() {
        return this.deltaHdrHistogramReservoir.getNextHdrHistogram();
    }

    @Override
    public void update(long duration, TimeUnit unit) {
        super.update(duration, unit);
        if (this.mirrors != null) {
            for (NicerTimer mirror : this.mirrors) {
                mirror.update(duration, unit);
            }
        }
    }
}

