/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.planning;

import io.engineblock.planning.ElementSequencer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.ToLongFunction;

public class IntervalSequencer<T>
implements ElementSequencer<T> {
    private List<T> elems;
    private ToLongFunction<T> ratioFunc;

    @Override
    public int[] sequenceByIndex(List<T> elements, ToLongFunction<T> ratioFunc) {
        ArrayList<OpSlot> ops = new ArrayList<OpSlot>();
        for (int i = 0; i < elements.size(); ++i) {
            T elem = elements.get(i);
            long freq = ratioFunc.applyAsLong(elem);
            int p = 0;
            while ((long)p < freq) {
                double pos = (double)p / (double)freq;
                ops.add(new OpSlot<T>(elem, pos, i));
                ++p;
            }
        }
        ops.sort(new OpComparator());
        return ops.stream().mapToInt(OpSlot::getElementRank).toArray();
    }

    private static final class OpComparator
    implements Comparator<OpSlot> {
        private OpComparator() {
        }

        @Override
        public int compare(OpSlot o1, OpSlot o2) {
            int timeOrder = Double.compare(o1.position, o2.position);
            if (timeOrder != 0) {
                return timeOrder;
            }
            return Integer.compare(o1.rank, o2.rank);
        }
    }

    private static final class OpSlot<T> {
        private T elem;
        private double position;
        private int rank;

        public OpSlot(T elem, double position, int rank) {
            this.elem = elem;
            this.position = position;
            this.rank = rank;
        }

        public T getElement() {
            return this.elem;
        }

        public int getElementRank() {
            return this.rank;
        }
    }
}

