/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.planning;

import io.engineblock.planning.BucketSequencer;
import io.engineblock.planning.ConcatSequencer;
import io.engineblock.planning.IntervalSequencer;
import java.util.List;
import java.util.function.ToLongFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequencePlanner<T> {
    private static final Logger logger = LoggerFactory.getLogger(SequencePlanner.class);
    private final List<T> elements;
    private int[] elementIndex;

    public SequencePlanner(List<T> elements, ToLongFunction<T> ratioFunc, SequencerType sequencerType) {
        switch (sequencerType) {
            case bucket: {
                logger.trace("sequencing elements by simple round-robin");
                this.elementIndex = new BucketSequencer<T>().sequenceByIndex(elements, ratioFunc);
                break;
            }
            case interval: {
                logger.trace("sequencing elements by interval and position");
                this.elementIndex = new IntervalSequencer<T>().sequenceByIndex(elements, ratioFunc);
                break;
            }
            case concat: {
                logger.trace("sequencing elements by concatenation");
                this.elementIndex = new ConcatSequencer<T>().sequenceByIndex(elements, ratioFunc);
            }
        }
        this.elements = elements;
    }

    public T get(long selector) {
        int index = (int)(selector % (long)this.elementIndex.length);
        index = this.elementIndex[index];
        return this.elements.get(index);
    }

    public static enum SequencerType {
        bucket,
        interval,
        concat;

    }
}

