/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.util;

import io.engineblock.util.Tagged;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class TagFilter {
    public static TagFilter MATCH_ALL = new TagFilter("");
    private Map<String, String> filter = new LinkedHashMap<String, String>();

    public TagFilter(String filterSpec) {
        if (filterSpec != null && !filterSpec.isEmpty()) {
            String[] keyvalues;
            for (String assignment : keyvalues = filterSpec.split("[, ] *")) {
                String value;
                String[] keyvalue = assignment.split("[:=]", 2);
                String key = keyvalue[0];
                String string = value = keyvalue.length > 1 ? keyvalue[1] : null;
                if (value != null) {
                    value = value.indexOf("'") == 0 && value.indexOf("'", 1) == value.length() - 1 ? value.substring(1, value.length() - 1) : value.trim();
                }
                this.filter.put(key, value);
            }
        }
    }

    protected Result matches(Map<String, String> tags) {
        ArrayList<String> log = new ArrayList<String>();
        boolean matched = true;
        for (String filterkey : this.filter.keySet()) {
            String filterval = this.filter.get(filterkey);
            String itemval = tags.get(filterkey);
            String detail = "filter(" + filterkey + (filterval != null ? ":" + filterval : "") + ") tag(" + (tags.containsKey(filterkey) ? filterkey : "") + (tags.get(filterkey) != null ? ":" + tags.get(filterkey) : "") + ")";
            if (filterval == null) {
                if (tags.containsKey(filterkey)) {
                    log.add("(\u2611, ) " + detail + ": matched names");
                    continue;
                }
                log.add("(\u2610, ) " + detail + ": did not match)");
                matched = false;
                continue;
            }
            Pattern filterpattern = Pattern.compile("^" + filterval + "$");
            if (itemval == null) {
                log.add("(\u2611,\u2610) " + detail + ": null tag value did not match '" + filterpattern + "'");
                matched = false;
                continue;
            }
            if (filterpattern.matcher(itemval).matches()) {
                log.add("(\u2611,\u2611) " + detail + ": matched pattern '" + filterpattern + "'");
                continue;
            }
            log.add("(\u2611,\u2610) " + detail + ": did not match '" + filterpattern + "'");
            matched = false;
        }
        return new Result(matched, log);
    }

    public Result matchesMap(Map<String, String> tags) {
        return this.matches(tags);
    }

    public Result matchesTaggedResult(Tagged item) {
        return this.matches(item.getTags());
    }

    public boolean matchesTagged(Tagged item) {
        return this.matches(item.getTags()).matched();
    }

    public Map<String, String> getMap() {
        return this.filter;
    }

    public static class Result {
        private boolean matched;
        private List<String> matchLog;

        public Result(boolean matched, List<String> log) {
            this.matched = matched;
            this.matchLog = log;
        }

        public static Result Matched(final String reason) {
            return new Result(true, (List<String>)new ArrayList<String>(){
                {
                    this.add(reason);
                }
            });
        }

        public static Result Unmatched(final String reason) {
            return new Result(false, (List<String>)new ArrayList<String>(){
                {
                    this.add(reason);
                }
            });
        }

        public boolean matched() {
            return this.matched;
        }

        public String getLog() {
            return this.matchLog.stream().collect(Collectors.joining("\n"));
        }
    }
}

