/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.basicsmappers;

import io.virtdata.api.Example;
import io.virtdata.api.Examples;
import io.virtdata.api.ThreadSafeMapper;
import java.util.ArrayList;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.chrono.GregorianChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

@Examples(value={@Example(value="ToEpochTimeUUID() // basetime 0, computed node data, empty clock data"), @Example(value="ToEpochTimeUUID(5234) // basetime 0, specified node data (5234), empty clock data"), @Example(value="ToEpochTimeUUID(31,337) // basetime 0, specified node data (31) and clock data (337)"), @Example(value="ToEpochTimeUUID('2017-01-01T23:59:59') // specified basetime, computed node data, empty clock data"), @Example(value="ToEpochTimeUUID('2012',12345) // basetime at start if 2012, with node data 12345, empty clock data"), @Example(value="ToEpochTimeUUID('20171231T1015.243',123,456) // ms basetime, specified node and clock data")})
@ThreadSafeMapper
public class DateTimeFormats {
    public static final DateTimeFormatter[] formatters = new DateTimeFormatter[]{DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss.SSSZ").withChronology(GregorianChronology.getInstance()), DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss").withChronology(GregorianChronology.getInstance()), ISODateTimeFormat.basicDateTime().withChronology(GregorianChronology.getInstance()), ISODateTimeFormat.basicDateTimeNoMillis().withZoneUTC().withChronology(GregorianChronology.getInstance()), ISODateTimeFormat.date().withZoneUTC().withChronology(GregorianChronology.getInstance()), DateTimeFormat.forPattern("yyyyMMdd").withZoneUTC().withChronology(GregorianChronology.getInstance()), DateTimeFormat.forPattern("yyyyMM").withZoneUTC().withChronology(GregorianChronology.getInstance()), DateTimeFormat.forPattern("yyyy").withZoneUTC().withChronology(GregorianChronology.getInstance())};
    public static DateTime gregorianCalendarStart = new DateTime(1582, 10, 15, 0, 0, DateTimeZone.UTC);

    /*
     * WARNING - void declaration
     */
    public static DateTime parseEpochTimeToDateTime(String timeString) {
        void var4_6;
        ArrayList<RuntimeException> exceptions = new ArrayList<RuntimeException>();
        DateTimeFormatter[] dateTimeFormatterArray = formatters;
        int n = dateTimeFormatterArray.length;
        boolean bl = false;
        while (var4_6 < n) {
            DateTimeFormatter dtf = dateTimeFormatterArray[var4_6];
            try {
                DateTime dateTime = dtf.withZoneUTC().parseDateTime(timeString);
                return dateTime;
            }
            catch (Exception e) {
                exceptions.add(new RuntimeException("as '" + dtf.print(DateTime.now()) + "': " + e.getMessage()));
                ++var4_6;
            }
        }
        String message = "";
        for (Exception exception : exceptions) {
            message = message + exception.getMessage() + "\n";
        }
        throw new RuntimeException("Unable to parse [" + timeString + "] with any of the parsers. exceptions:" + message + ", examples of valid formats are included above");
    }

    public static long parseEpochTimeToGregorianMillis(String timeString) {
        DateTime dateTime = DateTimeFormats.parseEpochTimeToDateTime(timeString);
        return new Duration(gregorianCalendarStart, dateTime).getMillis();
    }

    public static long parseEpochTimeToTimeUUIDTicks(String timeString) {
        long l = DateTimeFormats.parseEpochTimeToGregorianMillis(timeString);
        return l * 10000L;
    }
}

