/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.basicsmappers.from_long.to_bigdecimal;

import io.virtdata.api.ThreadSafeMapper;
import java.math.BigDecimal;
import java.util.function.LongFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafeMapper
public class ModuloToBigDecimal
implements LongFunction<BigDecimal> {
    private static final Logger logger = LoggerFactory.getLogger(ModuloToBigDecimal.class);
    private final long modulo;

    public ModuloToBigDecimal() {
        this.modulo = Long.MAX_VALUE;
    }

    public ModuloToBigDecimal(long modulo) {
        this.modulo = modulo;
    }

    @Override
    public BigDecimal apply(long value) {
        long ret = value % this.modulo & Long.MAX_VALUE;
        return BigDecimal.valueOf(ret);
    }
}

