/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.basicsmappers.from_long.to_time_types;

import io.virtdata.api.Example;
import io.virtdata.api.Examples;
import io.virtdata.api.ThreadSafeMapper;
import io.virtdata.basicsmappers.DateTimeFormats;
import java.util.function.LongUnaryOperator;
import org.joda.time.DateTime;

@Examples(value={@Example(value="StartingEpochMillis('2017-01-01T23:59:59')"), @Example(value="StartingEpochMillis('2012',12345)"), @Example(value="StartingEpochMillis('20171231T1015.243',123,456)")})
@ThreadSafeMapper
public class StartingEpochMillis
implements LongUnaryOperator {
    private final DateTime startingTime;
    private final long startingUnixEpochMillis;
    private final long headroom;

    public StartingEpochMillis(String baseTimeSpec) {
        this.startingTime = DateTimeFormats.parseEpochTimeToDateTime(baseTimeSpec);
        this.startingUnixEpochMillis = this.startingTime.getMillis();
        this.headroom = Long.MAX_VALUE - this.startingUnixEpochMillis;
    }

    @Override
    public long applyAsLong(long value) {
        return this.startingUnixEpochMillis + value % this.headroom;
    }
}

