/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.basicsmappers.unary_string;

import io.virtdata.api.DataMapper;
import io.virtdata.api.ThreadSafeMapper;
import io.virtdata.core.AllDataMapperLibraries;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.LongFunction;

@ThreadSafeMapper
public class FuncTemplate
implements LongFunction<String> {
    private static final String EXPR_BEGIN = "[[";
    private static final String EXPR_END = "]]";
    private String[] literals;
    private DataMapper<String>[] funcs;
    private final String rawTemplate;
    private static final ThreadLocal<StringBuilder> sb = ThreadLocal.withInitial(StringBuilder::new);

    public FuncTemplate(String rawTemplate) {
        this.rawTemplate = rawTemplate;
        this.parseTemplate(rawTemplate);
    }

    private void parseTemplate(String rawTemplate) {
        int pos = 0;
        ArrayList<String> lits = new ArrayList<String>();
        ArrayList<DataMapper<String>> funcs = new ArrayList<DataMapper<String>>();
        while (pos < rawTemplate.length()) {
            int startat = rawTemplate.indexOf(EXPR_BEGIN, pos);
            int endat = rawTemplate.indexOf(EXPR_END, pos);
            if (startat >= 0 && endat >= startat) {
                String pre = rawTemplate.substring(pos, startat);
                lits.add(pre);
                String expr = rawTemplate.substring(startat + 2, endat);
                Optional<DataMapper<String>> func = AllDataMapperLibraries.get().getStringDataMapper(expr);
                funcs.add(func.orElseThrow(() -> new RuntimeException("Unable to resolve function: " + expr)));
                pos = endat + 2;
                continue;
            }
            if (startat >= 0 || endat >= 0) {
                throw new RuntimeException("invalid (( and )) positions while parsing '" + rawTemplate + "' from position " + pos);
            }
            String remainder = rawTemplate.substring(pos, rawTemplate.length());
            lits.add(remainder);
            pos = rawTemplate.length();
        }
        if (lits.size() <= funcs.size()) {
            lits.add("");
        }
        this.literals = lits.toArray(new String[0]);
        this.funcs = funcs.toArray(new DataMapper[0]);
    }

    @Override
    public String apply(long value) {
        StringBuilder buffer = sb.get();
        buffer.setLength(0);
        buffer.append(this.literals[0]);
        if (this.literals.length > 1) {
            for (int i = 1; i < this.literals.length; ++i) {
                String genString = this.funcs[i - 1].get(value);
                buffer.append(genString);
                buffer.append(this.literals[i]);
            }
        }
        return buffer.toString();
    }
}

