/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.core;

import io.virtdata.api.DataMapper;
import io.virtdata.api.DataMapperLibrary;
import io.virtdata.core.DataMapperFunctionMapper;
import io.virtdata.core.DataMapperLibraryFinder;
import io.virtdata.core.ResolvedFunction;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllDataMapperLibraries
implements DataMapperLibrary {
    private static AllDataMapperLibraries instance = new AllDataMapperLibraries();
    private List<DataMapperLibrary> libraries = DataMapperLibraryFinder.getAll();
    private final Map<String, DataMapper<?>> threadSafeCache = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(AllDataMapperLibraries.class);

    private AllDataMapperLibraries() {
    }

    public static AllDataMapperLibraries get() {
        return instance;
    }

    @Override
    public String getLibraryName() {
        return "ALL";
    }

    private <T> Optional<DataMapper<T>> getDataMapperUnsynced(String spec) {
        Optional<ResolvedFunction> optionallyResolvedFunction;
        List<ResolvedFunction> resolvedFunctions = this.resolveFunctions(spec);
        if (resolvedFunctions.size() == 0) {
            throw new RuntimeException("Unable to resolve a mapping function for " + spec);
        }
        if (resolvedFunctions.size() > 1) {
            logger.warn("Found " + resolvedFunctions.size() + " resolved functions for '" + spec + "'. This library expects there to be exactly 1");
        }
        if ((optionallyResolvedFunction = Optional.ofNullable(resolvedFunctions.get(0))).isPresent()) {
            ResolvedFunction resolvedFunction = optionallyResolvedFunction.get();
        }
        Optional<DataMapper<T>> dataMapper = optionallyResolvedFunction.map(ResolvedFunction::getFunctionObject).map(DataMapperFunctionMapper::map);
        return dataMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Optional<DataMapper<T>> getDataMapper(String spec) {
        if (!this.canParseSpec(spec)) {
            throw new RuntimeException("No libraries could parse: " + spec);
        }
        AllDataMapperLibraries allDataMapperLibraries = this;
        synchronized (allDataMapperLibraries) {
            if (this.threadSafeCache.containsKey(spec)) {
                DataMapper<?> dataMapper = this.threadSafeCache.get(spec);
                if (dataMapper != null) {
                    return Optional.ofNullable(dataMapper);
                }
            } else {
                Optional<ResolvedFunction> optionallyResolvedFunction = this.resolveFunction(spec);
                if (optionallyResolvedFunction.isPresent()) {
                    ResolvedFunction resolvedFunction = optionallyResolvedFunction.get();
                    DataMapper mapper = DataMapperFunctionMapper.map(resolvedFunction.getFunctionObject());
                    if (resolvedFunction.isThreadSafe()) {
                        logger.debug("Function " + spec + " is marked as thread safe. Caching and sharing.");
                        this.threadSafeCache.put(spec, mapper);
                    } else {
                        logger.debug("Function " + spec + " is not thread safe.");
                        this.threadSafeCache.put(spec, null);
                    }
                } else {
                    return Optional.empty();
                }
                Optional<DataMapper<T>> optional = this.getDataMapperUnsynced(spec);
            }
        }
        return this.getDataMapperUnsynced(spec);
    }

    @Override
    public boolean canParseSpec(String spec) {
        return this.libraries.stream().map(gl -> gl.canParseSpec(spec)).anyMatch(l -> l);
    }

    @Override
    public List<ResolvedFunction> resolveFunctions(String spec) {
        ArrayList<ResolvedFunction> resolvedFunctions = new ArrayList<ResolvedFunction>();
        int parsingLibs = 0;
        for (DataMapperLibrary library : this.libraries) {
            if (!library.canParseSpec(spec)) continue;
            ++parsingLibs;
            List<ResolvedFunction> resolvedFunctions1 = library.resolveFunctions(spec);
            resolvedFunctions.addAll(resolvedFunctions1);
        }
        if (parsingLibs == 0) {
            throw new RuntimeException("No library could parse: " + spec);
        }
        return resolvedFunctions;
    }

    @Override
    public Optional<ResolvedFunction> resolveFunction(String spec) {
        List<ResolvedFunction> resolvedFunctionList = this.resolveFunctions(spec);
        if (resolvedFunctionList.size() == 0) {
            logger.warn("Unable to find data mapper for spec '" + spec + "' in any libimpl, searched in " + this.toString());
            return Optional.empty();
        }
        if (resolvedFunctionList.size() > 1) {
            String resolvedNames = resolvedFunctionList.stream().map(r -> r.getClass().getCanonicalName()).collect(Collectors.joining());
            logger.warn("Found more than one matching data mapper for spec '" + spec + "' : " + resolvedNames);
        }
        return Optional.of(resolvedFunctionList.get(0));
    }

    @Override
    public List<String> getDataMapperNames() {
        ArrayList<String> genNames = new ArrayList<String>();
        for (DataMapperLibrary library : this.libraries) {
            List libGenNames = library.getDataMapperNames().stream().map(genName -> library.getLibraryName() + "::" + genName).collect(Collectors.toList());
            genNames.addAll(libGenNames);
        }
        genNames.sort(Comparator.naturalOrder());
        return genNames;
    }

    public String toString() {
        return AllDataMapperLibraries.class.getSimpleName() + ":" + this.libraries.stream().map(DataMapperLibrary::getLibraryName).collect(Collectors.joining(",", "[", "]"));
    }
}

