/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libimpl.continuous;

import io.virtdata.api.DataMapperLibrary;
import io.virtdata.api.ValueType;
import io.virtdata.api.specs.SpecData;
import io.virtdata.core.ResolvedFunction;
import io.virtdata.libimpl.continuous.InterpolatingIntDoubleSampler;
import io.virtdata.libimpl.continuous.InterpolatingLongDoubleSampler;
import io.virtdata.libimpl.continuous.RealDistributionICDSource;
import io.virtdata.libimpl.continuous.RealIntDoubleSampler;
import io.virtdata.libimpl.continuous.RealLongDoubleSampler;
import io.virtdata.reflection.ConstructorResolver;
import io.virtdata.reflection.DeferredConstructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.IntToDoubleFunction;
import java.util.function.LongToDoubleFunction;
import org.apache.commons.math4.distribution.AbstractRealDistribution;
import org.apache.commons.math4.distribution.BetaDistribution;
import org.apache.commons.math4.distribution.CauchyDistribution;
import org.apache.commons.math4.distribution.ChiSquaredDistribution;
import org.apache.commons.math4.distribution.ConstantRealDistribution;
import org.apache.commons.math4.distribution.EmpiricalDistribution;
import org.apache.commons.math4.distribution.EnumeratedRealDistribution;
import org.apache.commons.math4.distribution.ExponentialDistribution;
import org.apache.commons.math4.distribution.FDistribution;
import org.apache.commons.math4.distribution.GammaDistribution;
import org.apache.commons.math4.distribution.GumbelDistribution;
import org.apache.commons.math4.distribution.LaplaceDistribution;
import org.apache.commons.math4.distribution.LevyDistribution;
import org.apache.commons.math4.distribution.LogNormalDistribution;
import org.apache.commons.math4.distribution.LogisticDistribution;
import org.apache.commons.math4.distribution.NakagamiDistribution;
import org.apache.commons.math4.distribution.NormalDistribution;
import org.apache.commons.math4.distribution.ParetoDistribution;
import org.apache.commons.math4.distribution.TDistribution;
import org.apache.commons.math4.distribution.TriangularDistribution;
import org.apache.commons.math4.distribution.UniformRealDistribution;
import org.apache.commons.math4.distribution.WeibullDistribution;

public class RealDistributions
implements DataMapperLibrary {
    private static final String MAPTO = "mapto_";
    private static final String HASHTO = "hashto_";
    private static final String COMPUTE = "compute_";
    private static final String INTERPOLATE = "interpolate_";

    public static LongToDoubleFunction forSpec(String spec) {
        Optional<ResolvedFunction> resolvedFunction = new RealDistributions().resolveFunction(spec);
        return resolvedFunction.map(ResolvedFunction::getFunctionObject).map(f -> (LongToDoubleFunction)f).orElseThrow(() -> new RuntimeException("Invalid spec: " + spec));
    }

    private static String distributionNameFor(String specName) {
        return specName.replaceAll(COMPUTE, "").replaceAll(INTERPOLATE, "").replaceAll(MAPTO, "").replaceAll(HASHTO, "");
    }

    @Override
    public String getLibraryName() {
        return "math4-ccurves";
    }

    @Override
    public boolean canParseSpec(String specifier) {
        Optional<SpecData> optionalData = SpecData.forOptionalSpec(specifier);
        if (!optionalData.isPresent()) {
            return false;
        }
        SpecData specData = optionalData.get();
        try {
            String distName = RealDistributions.distributionNameFor(specData.getFuncName());
            RealDistribution.valueOf(distName);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public Optional<ResolvedFunction> resolveFunction(String spec) {
        return this.resolveFunction(spec, ValueType.LONG);
    }

    private Optional<ResolvedFunction> resolveFunction(String spec, ValueType inputType) {
        if (!this.canParseSpec(spec)) {
            return Optional.empty();
        }
        SpecData specData = SpecData.forSpec(spec);
        String funcName = specData.getFuncName();
        RealDistribution realDistribution = RealDistribution.valueOf(RealDistributions.distributionNameFor(funcName));
        Class<? extends AbstractRealDistribution> distributionClass = realDistribution.getDistributionClass();
        DeferredConstructor<? extends AbstractRealDistribution> deferred = ConstructorResolver.resolve(distributionClass, specData.getArgs());
        AbstractRealDistribution distribution = deferred.construct();
        boolean interpolate = !funcName.contains(COMPUTE) || funcName.contains(INTERPOLATE);
        boolean hashto = !funcName.contains(MAPTO) || funcName.contains(HASHTO);
        RealDistributionICDSource icdSource = new RealDistributionICDSource(distribution);
        if (inputType == ValueType.LONG) {
            LongToDoubleFunction samplingFunction = null;
            samplingFunction = interpolate ? new InterpolatingLongDoubleSampler(icdSource, 1000, hashto) : new RealLongDoubleSampler(icdSource, hashto);
            return Optional.of(new ResolvedFunction(samplingFunction, true));
        }
        if (inputType == ValueType.INT) {
            IntToDoubleFunction samplingFunction = null;
            samplingFunction = interpolate ? new InterpolatingIntDoubleSampler(icdSource, 1000, hashto) : new RealIntDoubleSampler(icdSource, hashto);
            return Optional.of(new ResolvedFunction(samplingFunction, true));
        }
        return Optional.empty();
    }

    @Override
    public List<ResolvedFunction> resolveFunctions(String specifier) {
        ArrayList<ResolvedFunction> resolvedList = new ArrayList<ResolvedFunction>();
        this.resolveFunction(specifier, ValueType.LONG).map(resolvedList::add);
        this.resolveFunction(specifier, ValueType.INT).map(resolvedList::add);
        return resolvedList;
    }

    @Override
    public List<String> getDataMapperNames() {
        ArrayList<String> names = new ArrayList<String>();
        Arrays.stream(RealDistribution.values()).map(String::valueOf).forEach(n -> {
            names.add((String)n);
            names.add(MAPTO + n);
            names.add("mapto_compute_" + n);
            names.add(COMPUTE + n);
        });
        return names;
    }

    private static enum RealDistribution {
        levy(LevyDistribution.class),
        nakagami(NakagamiDistribution.class),
        triangular(TriangularDistribution.class),
        exponential(ExponentialDistribution.class),
        logistic(LogisticDistribution.class),
        enumerated_real(EnumeratedRealDistribution.class),
        laplace(LaplaceDistribution.class),
        log_normal(LogNormalDistribution.class),
        cauchy(CauchyDistribution.class),
        f(FDistribution.class),
        t(TDistribution.class),
        empirical(EmpiricalDistribution.class),
        normal(NormalDistribution.class),
        weibull(WeibullDistribution.class),
        chi_squared(ChiSquaredDistribution.class),
        gumbel(GumbelDistribution.class),
        constant_real(ConstantRealDistribution.class),
        beta(BetaDistribution.class),
        pareto(ParetoDistribution.class),
        gamma(GammaDistribution.class),
        uniform_real(UniformRealDistribution.class);

        private final Class<? extends AbstractRealDistribution> distribution;

        private RealDistribution(Class<? extends AbstractRealDistribution> distribution) {
            this.distribution = distribution;
        }

        public Class<? extends AbstractRealDistribution> getDistributionClass() {
            return this.distribution;
        }
    }
}

