/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libimpl.discrete;

import io.virtdata.libimpl.ThreadSafeHash;
import java.util.function.DoubleToIntFunction;
import java.util.function.IntToLongFunction;

public class DiscreteIntLongSampler
implements IntToLongFunction {
    private final DoubleToIntFunction f;
    private ThreadSafeHash hash;

    public DiscreteIntLongSampler(DoubleToIntFunction parentFunc, boolean hash) {
        this.f = parentFunc;
        if (hash) {
            this.hash = new ThreadSafeHash();
        }
    }

    @Override
    public long applyAsLong(int input) {
        int value = input;
        if (this.hash != null) {
            value = (int)(this.hash.applyAsLong(value) % Integer.MAX_VALUE);
        }
        double unit = (double)value / 2.147483647E9;
        int sample = this.f.applyAsInt(unit);
        return sample;
    }
}

