/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libraryimpl;

import io.virtdata.api.FunctionType;
import io.virtdata.libraryimpl.FunctionComposer;
import io.virtdata.libraryimpl.composers.ComposerForDoubleFunction;
import io.virtdata.libraryimpl.composers.ComposerForDoubleToIntFunction;
import io.virtdata.libraryimpl.composers.ComposerForDoubleToLongFunction;
import io.virtdata.libraryimpl.composers.ComposerForDoubleUnaryOperator;
import io.virtdata.libraryimpl.composers.ComposerForFunction;
import io.virtdata.libraryimpl.composers.ComposerForIntFunction;
import io.virtdata.libraryimpl.composers.ComposerForIntToDoubleFunction;
import io.virtdata.libraryimpl.composers.ComposerForIntToLongFunction;
import io.virtdata.libraryimpl.composers.ComposerForIntUnaryOperator;
import io.virtdata.libraryimpl.composers.ComposerForLongFunction;
import io.virtdata.libraryimpl.composers.ComposerForLongToDoubleFunction;
import io.virtdata.libraryimpl.composers.ComposerForLongToIntFunction;
import io.virtdata.libraryimpl.composers.ComposerForLongUnaryOperator;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;

public class FunctionAssembly
implements FunctionComposer {
    private FunctionComposer<?> composer = null;

    @Override
    public Object getFunctionObject() {
        if (this.composer != null) {
            return this.composer.getFunctionObject();
        }
        throw new RuntimeException("No function have been passed for assembly.");
    }

    @Override
    public FunctionComposer andThen(Object outer) {
        this.composer = this.composer != null ? this.composer.andThen(outer) : this.andThenInitial(outer);
        return this.composer;
    }

    private FunctionComposer<?> andThenInitial(Object o) {
        FunctionType functionType = FunctionType.valueOf(o);
        switch (functionType) {
            case long_long: {
                return new ComposerForLongUnaryOperator((LongUnaryOperator)o);
            }
            case long_int: {
                return new ComposerForLongToIntFunction((LongToIntFunction)o);
            }
            case long_double: {
                return new ComposerForLongToDoubleFunction((LongToDoubleFunction)o);
            }
            case long_T: {
                return new ComposerForLongFunction((LongFunction)o);
            }
            case int_int: {
                return new ComposerForIntUnaryOperator((IntUnaryOperator)o);
            }
            case int_long: {
                return new ComposerForIntToLongFunction((IntToLongFunction)o);
            }
            case int_double: {
                return new ComposerForIntToDoubleFunction((IntToDoubleFunction)o);
            }
            case int_T: {
                return new ComposerForIntFunction((IntFunction)o);
            }
            case double_double: {
                return new ComposerForDoubleUnaryOperator((DoubleUnaryOperator)o);
            }
            case double_long: {
                return new ComposerForDoubleToLongFunction((DoubleToLongFunction)o);
            }
            case double_int: {
                return new ComposerForDoubleToIntFunction((DoubleToIntFunction)o);
            }
            case double_T: {
                return new ComposerForDoubleFunction((DoubleFunction)o);
            }
            case R_T: {
                return new ComposerForFunction((Function)o);
            }
        }
        throw new RuntimeException("Unrecognized function type:" + (Object)((Object)functionType));
    }
}

