/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libraryimpl.composers;

import io.virtdata.api.FunctionType;
import io.virtdata.libraryimpl.FunctionComposer;
import io.virtdata.libraryimpl.composers.ComposerForIntToDoubleFunction;
import io.virtdata.libraryimpl.composers.ComposerForIntToLongFunction;
import io.virtdata.libraryimpl.composers.ComposerForIntUnaryOperator;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;

public class ComposerForIntFunction
implements FunctionComposer<IntFunction<?>> {
    private final IntFunction<?> inner;

    public ComposerForIntFunction(IntFunction<?> inner) {
        this.inner = inner;
    }

    @Override
    public FunctionComposer<?> andThen(Object outer) {
        FunctionType functionType = FunctionType.valueOf(outer);
        switch (functionType) {
            case long_long: {
                IntToLongFunction f1 = i -> ((LongUnaryOperator)outer).applyAsLong(((Long)this.inner.apply(i)).intValue());
                return new ComposerForIntToLongFunction(f1);
            }
            case long_T: {
                IntFunction<Object> f2 = i -> ((LongFunction)outer).apply((Long)this.inner.apply(i));
                return new ComposerForIntFunction(f2);
            }
            case long_int: {
                IntUnaryOperator f3 = i -> ((LongToIntFunction)outer).applyAsInt((Long)this.inner.apply(i));
                return new ComposerForIntUnaryOperator(f3);
            }
            case long_double: {
                IntToDoubleFunction f4 = i -> ((LongToDoubleFunction)outer).applyAsDouble((Long)this.inner.apply(i));
                return new ComposerForIntToDoubleFunction(f4);
            }
            case int_int: {
                IntUnaryOperator f5 = i -> ((IntUnaryOperator)outer).applyAsInt((Integer)this.inner.apply(i));
                return new ComposerForIntUnaryOperator(f5);
            }
            case R_T: {
                IntFunction<Object> f6 = i -> ((IntFunction)outer).apply((Integer)this.inner.apply(i));
                return new ComposerForIntFunction(f6);
            }
            case int_long: {
                IntToLongFunction f7 = i -> ((IntToLongFunction)outer).applyAsLong((Integer)this.inner.apply(i));
                return new ComposerForIntToLongFunction(f7);
            }
            case int_double: {
                IntToDoubleFunction f8 = i -> ((IntToDoubleFunction)outer).applyAsDouble((Integer)this.inner.apply(i));
                return new ComposerForIntToDoubleFunction(f8);
            }
            case int_T: {
                IntFunction<Object> f9 = i -> ((IntFunction)outer).apply((Integer)this.inner.apply(i));
                return new ComposerForIntFunction(f9);
            }
            case double_double: {
                IntToDoubleFunction f10 = i -> ((DoubleUnaryOperator)outer).applyAsDouble((Double)this.inner.apply(i));
                return new ComposerForIntToDoubleFunction(f10);
            }
            case double_long: {
                IntToLongFunction f11 = i -> ((DoubleToLongFunction)outer).applyAsLong((Double)this.inner.apply(i));
                return new ComposerForIntToLongFunction(f11);
            }
            case double_int: {
                IntUnaryOperator f12 = i -> ((DoubleToIntFunction)outer).applyAsInt((Double)this.inner.apply(i));
                return new ComposerForIntUnaryOperator(f12);
            }
            case double_T: {
                IntFunction<Object> f13 = i -> ((DoubleFunction)outer).apply((Double)this.inner.apply(i));
                return new ComposerForIntFunction(f13);
            }
        }
        throw new RuntimeException((Object)((Object)functionType) + " is not recognized");
    }

    @Override
    public Object getFunctionObject() {
        return this.inner;
    }
}

