/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libraryimpl.composers;

import io.virtdata.api.FunctionType;
import io.virtdata.libraryimpl.FunctionComposer;
import io.virtdata.libraryimpl.composers.ComposerForLongToDoubleFunction;
import io.virtdata.libraryimpl.composers.ComposerForLongToIntFunction;
import io.virtdata.libraryimpl.composers.ComposerForLongUnaryOperator;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;

public class ComposerForLongFunction
implements FunctionComposer<LongFunction<?>> {
    private final LongFunction<?> inner;

    public ComposerForLongFunction(LongFunction<?> inner) {
        this.inner = inner;
    }

    @Override
    public Object getFunctionObject() {
        return this.inner;
    }

    @Override
    public FunctionComposer andThen(Object outer) {
        FunctionType functionType = FunctionType.valueOf(outer);
        switch (functionType) {
            case long_long: {
                LongUnaryOperator f1 = l -> ((LongUnaryOperator)outer).applyAsLong((Long)this.inner.apply(l));
                return new ComposerForLongUnaryOperator(f1);
            }
            case long_T: {
                LongFunction<Object> f2 = l -> ((LongFunction)outer).apply((Long)this.inner.apply(l));
                return new ComposerForLongFunction(f2);
            }
            case long_int: {
                LongToIntFunction f3 = l -> ((LongToIntFunction)outer).applyAsInt((Long)this.inner.apply(l));
                return new ComposerForLongToIntFunction(f3);
            }
            case long_double: {
                LongToDoubleFunction f4 = l -> ((LongToDoubleFunction)outer).applyAsDouble((Long)this.inner.apply(l));
                return new ComposerForLongToDoubleFunction(f4);
            }
            case R_T: {
                LongFunction<Object> f5 = l -> ((Function)outer).apply(this.inner.apply(l));
                return new ComposerForLongFunction(f5);
            }
            case int_int: {
                LongToIntFunction f6 = l -> ((IntUnaryOperator)outer).applyAsInt((Integer)this.inner.apply(l));
                return new ComposerForLongToIntFunction(f6);
            }
            case int_long: {
                LongUnaryOperator f7 = l -> ((IntToLongFunction)outer).applyAsLong((Integer)this.inner.apply(l));
                return new ComposerForLongUnaryOperator(f7);
            }
            case int_double: {
                LongToDoubleFunction f8 = l -> ((IntToDoubleFunction)outer).applyAsDouble((Integer)this.inner.apply(l));
                return new ComposerForLongToDoubleFunction(f8);
            }
            case int_T: {
                LongFunction<Object> f9 = l -> ((IntFunction)outer).apply((Integer)this.inner.apply(l));
                return new ComposerForLongFunction(f9);
            }
            case double_double: {
                LongToDoubleFunction f10 = l -> ((DoubleUnaryOperator)outer).applyAsDouble((Double)this.inner.apply(l));
                return new ComposerForLongToDoubleFunction(f10);
            }
            case double_long: {
                LongUnaryOperator f11 = l -> ((DoubleToLongFunction)outer).applyAsLong((Double)this.inner.apply(l));
                return new ComposerForLongUnaryOperator(f11);
            }
            case double_int: {
                LongToIntFunction f12 = l -> ((DoubleToIntFunction)outer).applyAsInt((Double)this.inner.apply(l));
                return new ComposerForLongToIntFunction(f12);
            }
            case double_T: {
                LongFunction<Object> f13 = l -> ((DoubleFunction)outer).apply((Double)this.inner.apply(l));
                return new ComposerForLongFunction(f13);
            }
        }
        throw new RuntimeException((Object)((Object)functionType) + " is not recognized");
    }
}

