/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.templates;

import io.virtdata.api.ValuesArrayBinder;
import java.util.ArrayList;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringCompositor
implements ValuesArrayBinder<StringCompositor, String> {
    private static Pattern tokenPattern = Pattern.compile("(?<section>(?<literal>[^{}]+)?(?<anchor>\\{(?<token>[a-zA-Z.-]+)?\\})?)");
    private String[] templateSegments;
    private int buffersize = 0;

    public StringCompositor(String template) {
        this.templateSegments = this.parseTemplate(template);
    }

    private String[] parseTemplate(String template) {
        Matcher matcher = tokenPattern.matcher(template);
        ArrayList<String> sections = new ArrayList<String>();
        boolean previous = false;
        int counter = 0;
        while (matcher.find()) {
            String literal = matcher.group("literal");
            String anchor = matcher.group("anchor");
            String token = matcher.group("token");
            if (anchor == null && literal == null) break;
            sections.add(Optional.ofNullable(literal).orElse(""));
            if (anchor == null) continue;
            sections.add(Optional.ofNullable(token).orElse(String.valueOf(counter++)));
        }
        if (sections.size() % 2 == 0) {
            sections.add("");
        }
        return sections.toArray(new String[0]);
    }

    @Override
    public String bindValues(StringCompositor context, Object[] values) {
        StringBuilder sb = new StringBuilder(this.buffersize);
        int len = values.length;
        if (values.length != this.templateSegments.length >> 1) {
            throw new RuntimeException("values array has " + values.length + " elements, but  the template needs " + (this.templateSegments.length >> 1));
        }
        sb.append(this.templateSegments[0]);
        for (int i = 0; i < len; ++i) {
            sb.append(values[i]);
            sb.append(this.templateSegments[2 * i + 2]);
        }
        if (sb.length() > this.buffersize) {
            this.buffersize = sb.length() + 5;
        }
        return sb.toString();
    }
}

