/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.valuesapp;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class IndexedThreadFactory
implements ThreadFactory {
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private String name = Thread.currentThread().getName() + "-factory";
    private AtomicInteger threadIndexer = new AtomicInteger(0);

    public IndexedThreadFactory(String name, Thread.UncaughtExceptionHandler exceptionHandler) {
        this.name = name;
        this.uncaughtExceptionHandler = exceptionHandler;
    }

    @Override
    public IndexedThread newThread(Runnable r) {
        int threadIndex = this.threadIndexer.incrementAndGet();
        IndexedThread thread = new IndexedThread(threadIndex, r);
        thread.setName(this.name + String.format(":%03d", threadIndex));
        thread.setMetricName(thread.getName().split(":")[0].split("/")[0]);
        if (this.uncaughtExceptionHandler != null) {
            thread.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
        }
        return thread;
    }

    public class IndexedThread
    extends Thread {
        private int threadIndex;
        private String metricName;

        public IndexedThread(int threadIndex, Runnable r) {
            super(r);
            this.metricName = "default-name-" + Thread.currentThread().getName();
            this.threadIndex = threadIndex;
        }

        public int getThreadIndex() {
            return this.threadIndex;
        }

        public void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public String getMetricName() {
            return this.metricName;
        }
    }
}

