/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis;

import org.apache.commons.math4.analysis.BivariateFunction;
import org.apache.commons.math4.analysis.MultivariateFunction;
import org.apache.commons.math4.analysis.MultivariateVectorFunction;
import org.apache.commons.math4.analysis.UnivariateFunction;
import org.apache.commons.math4.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math4.analysis.differentiation.MultivariateDifferentiableFunction;
import org.apache.commons.math4.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math4.analysis.function.Identity;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.NumberIsTooLargeException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.numbers.arrays.LinearCombination;

public class FunctionUtils {
    private FunctionUtils() {
    }

    public static UnivariateFunction compose(final UnivariateFunction ... f) {
        return new UnivariateFunction(){

            @Override
            public double value(double x) {
                double r = x;
                for (int i = f.length - 1; i >= 0; --i) {
                    r = f[i].value(r);
                }
                return r;
            }
        };
    }

    public static UnivariateDifferentiableFunction compose(final UnivariateDifferentiableFunction ... f) {
        return new UnivariateDifferentiableFunction(){

            @Override
            public double value(double t) {
                double r = t;
                for (int i = f.length - 1; i >= 0; --i) {
                    r = f[i].value(r);
                }
                return r;
            }

            @Override
            public DerivativeStructure value(DerivativeStructure t) {
                DerivativeStructure r = t;
                for (int i = f.length - 1; i >= 0; --i) {
                    r = f[i].value(r);
                }
                return r;
            }
        };
    }

    public static UnivariateFunction add(final UnivariateFunction ... f) {
        return new UnivariateFunction(){

            @Override
            public double value(double x) {
                double r = f[0].value(x);
                for (int i = 1; i < f.length; ++i) {
                    r += f[i].value(x);
                }
                return r;
            }
        };
    }

    public static UnivariateDifferentiableFunction add(final UnivariateDifferentiableFunction ... f) {
        return new UnivariateDifferentiableFunction(){

            @Override
            public double value(double t) {
                double r = f[0].value(t);
                for (int i = 1; i < f.length; ++i) {
                    r += f[i].value(t);
                }
                return r;
            }

            @Override
            public DerivativeStructure value(DerivativeStructure t) throws DimensionMismatchException {
                DerivativeStructure r = f[0].value(t);
                for (int i = 1; i < f.length; ++i) {
                    r = r.add(f[i].value(t));
                }
                return r;
            }
        };
    }

    public static UnivariateFunction multiply(final UnivariateFunction ... f) {
        return new UnivariateFunction(){

            @Override
            public double value(double x) {
                double r = f[0].value(x);
                for (int i = 1; i < f.length; ++i) {
                    r *= f[i].value(x);
                }
                return r;
            }
        };
    }

    public static UnivariateDifferentiableFunction multiply(final UnivariateDifferentiableFunction ... f) {
        return new UnivariateDifferentiableFunction(){

            @Override
            public double value(double t) {
                double r = f[0].value(t);
                for (int i = 1; i < f.length; ++i) {
                    r *= f[i].value(t);
                }
                return r;
            }

            @Override
            public DerivativeStructure value(DerivativeStructure t) {
                DerivativeStructure r = f[0].value(t);
                for (int i = 1; i < f.length; ++i) {
                    r = r.multiply(f[i].value(t));
                }
                return r;
            }
        };
    }

    public static UnivariateFunction combine(final BivariateFunction combiner, final UnivariateFunction f, final UnivariateFunction g) {
        return new UnivariateFunction(){

            @Override
            public double value(double x) {
                return combiner.value(f.value(x), g.value(x));
            }
        };
    }

    public static MultivariateFunction collector(final BivariateFunction combiner, final UnivariateFunction f, final double initialValue) {
        return new MultivariateFunction(){

            @Override
            public double value(double[] point) {
                double result = combiner.value(initialValue, f.value(point[0]));
                for (int i = 1; i < point.length; ++i) {
                    result = combiner.value(result, f.value(point[i]));
                }
                return result;
            }
        };
    }

    public static MultivariateFunction collector(BivariateFunction combiner, double initialValue) {
        return FunctionUtils.collector(combiner, new Identity(), initialValue);
    }

    public static UnivariateFunction fix1stArgument(final BivariateFunction f, final double fixed) {
        return new UnivariateFunction(){

            @Override
            public double value(double x) {
                return f.value(fixed, x);
            }
        };
    }

    public static UnivariateFunction fix2ndArgument(final BivariateFunction f, final double fixed) {
        return new UnivariateFunction(){

            @Override
            public double value(double x) {
                return f.value(x, fixed);
            }
        };
    }

    public static double[] sample(UnivariateFunction f, double min, double max, int n) throws NumberIsTooLargeException, NotStrictlyPositiveException {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NOT_POSITIVE_NUMBER_OF_SAMPLES, n);
        }
        if (min >= max) {
            throw new NumberIsTooLargeException(min, (Number)max, false);
        }
        double[] s = new double[n];
        double h = (max - min) / (double)n;
        for (int i = 0; i < n; ++i) {
            s[i] = f.value(min + (double)i * h);
        }
        return s;
    }

    public static UnivariateDifferentiableFunction toDifferentiable(final UnivariateFunction f, final UnivariateFunction ... derivatives) {
        return new UnivariateDifferentiableFunction(){

            @Override
            public double value(double x) {
                return f.value(x);
            }

            @Override
            public DerivativeStructure value(DerivativeStructure x) {
                if (x.getOrder() > derivatives.length) {
                    throw new NumberIsTooLargeException(x.getOrder(), (Number)derivatives.length, true);
                }
                double[] packed = new double[x.getOrder() + 1];
                packed[0] = f.value(x.getValue());
                for (int i = 0; i < x.getOrder(); ++i) {
                    packed[i + 1] = derivatives[i].value(x.getValue());
                }
                return x.compose(packed);
            }
        };
    }

    public static MultivariateDifferentiableFunction toDifferentiable(final MultivariateFunction f, final MultivariateVectorFunction gradient) {
        return new MultivariateDifferentiableFunction(){

            @Override
            public double value(double[] point) {
                return f.value(point);
            }

            @Override
            public DerivativeStructure value(DerivativeStructure[] point) {
                double[] dPoint = new double[point.length];
                for (int i = 0; i < point.length; ++i) {
                    dPoint[i] = point[i].getValue();
                    if (point[i].getOrder() <= 1) continue;
                    throw new NumberIsTooLargeException(point[i].getOrder(), (Number)1, true);
                }
                double v = f.value(dPoint);
                double[] dv = gradient.value(dPoint);
                if (dv.length != point.length) {
                    throw new DimensionMismatchException(dv.length, point.length);
                }
                int parameters = point[0].getFreeParameters();
                double[] partials = new double[point.length];
                double[] packed = new double[parameters + 1];
                packed[0] = v;
                int[] orders = new int[parameters];
                for (int i = 0; i < parameters; ++i) {
                    orders[i] = 1;
                    for (int j = 0; j < point.length; ++j) {
                        partials[j] = point[j].getPartialDerivative(orders);
                    }
                    orders[i] = 0;
                    packed[i + 1] = LinearCombination.value(dv, partials);
                }
                return new DerivativeStructure(parameters, 1, packed);
            }
        };
    }

    public static UnivariateFunction derivative(final UnivariateDifferentiableFunction f, final int order) {
        return new UnivariateFunction(){

            @Override
            public double value(double x) {
                DerivativeStructure dsX = new DerivativeStructure(1, order, 0, x);
                return f.value(dsX).getPartialDerivative(order);
            }
        };
    }

    public static MultivariateFunction derivative(final MultivariateDifferentiableFunction f, final int[] orders) {
        return new MultivariateFunction(){

            @Override
            public double value(double[] point) {
                int sumOrders = 0;
                for (int order : orders) {
                    sumOrders += order;
                }
                DerivativeStructure[] dsPoint = new DerivativeStructure[point.length];
                for (int i = 0; i < point.length; ++i) {
                    dsPoint[i] = new DerivativeStructure(point.length, sumOrders, i, point[i]);
                }
                return f.value(dsPoint).getPartialDerivative(orders);
            }
        };
    }
}

