/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.integration.gauss;

import java.util.Arrays;
import org.apache.commons.math4.analysis.integration.gauss.BaseRuleFactory;
import org.apache.commons.math4.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math4.analysis.polynomials.PolynomialsUtils;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.linear.EigenDecomposition;
import org.apache.commons.math4.linear.MatrixUtils;
import org.apache.commons.math4.linear.RealMatrix;
import org.apache.commons.math4.util.Pair;

public class LaguerreRuleFactory
extends BaseRuleFactory<Double> {
    @Override
    protected Pair<Double[], Double[]> computeRule(int numberOfPoints) throws DimensionMismatchException {
        RealMatrix companionMatrix = this.companionMatrix(numberOfPoints);
        EigenDecomposition eigen = new EigenDecomposition(companionMatrix);
        double[] roots = eigen.getRealEigenvalues();
        Arrays.sort(roots);
        Double[] points = new Double[numberOfPoints];
        Double[] weights = new Double[numberOfPoints];
        int n1 = numberOfPoints + 1;
        long n1Squared = (long)n1 * (long)n1;
        PolynomialFunction laguerreN1 = PolynomialsUtils.createLaguerrePolynomial(n1);
        for (int i = 0; i < numberOfPoints; ++i) {
            double xi = roots[i];
            points[i] = xi;
            double val = laguerreN1.value(xi);
            weights[i] = xi / (double)n1Squared / (val * val);
        }
        return new Pair<Double[], Double[]>(points, weights);
    }

    private RealMatrix companionMatrix(int degree) {
        RealMatrix c = MatrixUtils.createRealMatrix(degree, degree);
        for (int i = 0; i < degree; ++i) {
            c.setEntry(i, i, 2 * i + 1);
            if (i + 1 < degree) {
                c.setEntry(i + 1, i, -(i + 1));
            }
            if (i - 1 < 0) continue;
            c.setEntry(i - 1, i, -i);
        }
        return c;
    }
}

