/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.distribution;

import org.apache.commons.math4.distribution.AbstractRealDistribution;
import org.apache.commons.math4.distribution.RealDistribution;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.OutOfRangeException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.AhrensDieterExponentialSampler;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;

public class ExponentialDistribution
extends AbstractRealDistribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 20160311L;
    private final double mean;
    private final double logMean;
    private final double solverAbsoluteAccuracy;

    public ExponentialDistribution(double mean) {
        this(mean, 1.0E-9);
    }

    public ExponentialDistribution(double mean, double inverseCumAccuracy) throws NotStrictlyPositiveException {
        if (mean <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.MEAN, mean);
        }
        this.mean = mean;
        this.logMean = FastMath.log(mean);
        this.solverAbsoluteAccuracy = inverseCumAccuracy;
    }

    public double getMean() {
        return this.mean;
    }

    @Override
    public double density(double x) {
        double logDensity = this.logDensity(x);
        return logDensity == Double.NEGATIVE_INFINITY ? 0.0 : FastMath.exp(logDensity);
    }

    @Override
    public double logDensity(double x) {
        if (x < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return -x / this.mean - this.logMean;
    }

    @Override
    public double cumulativeProbability(double x) {
        double ret = x <= 0.0 ? 0.0 : 1.0 - FastMath.exp(-x / this.mean);
        return ret;
    }

    @Override
    public double inverseCumulativeProbability(double p) throws OutOfRangeException {
        if (p < 0.0 || p > 1.0) {
            throw new OutOfRangeException(p, (Number)0.0, 1.0);
        }
        double ret = p == 1.0 ? Double.POSITIVE_INFINITY : -this.mean * FastMath.log(1.0 - p);
        return ret;
    }

    @Override
    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    @Override
    public double getNumericalMean() {
        return this.getMean();
    }

    @Override
    public double getNumericalVariance() {
        double m = this.getMean();
        return m * m;
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public RealDistribution.Sampler createSampler(final UniformRandomProvider rng) {
        return new RealDistribution.Sampler(){
            private final ContinuousSampler sampler;
            {
                this.sampler = new AhrensDieterExponentialSampler(rng, ExponentialDistribution.this.mean);
            }

            @Override
            public double sample() {
                return this.sampler.sample();
            }
        };
    }
}

