/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.distribution;

import org.apache.commons.math4.distribution.AbstractRealDistribution;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.NumberIsTooSmallException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.numbers.gamma.Gamma;
import org.apache.commons.numbers.gamma.RegularizedGamma;

public class NakagamiDistribution
extends AbstractRealDistribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 20160311L;
    private final double mu;
    private final double omega;
    private final double inverseAbsoluteAccuracy;

    public NakagamiDistribution(double mu, double omega) {
        this(mu, omega, 1.0E-9);
    }

    public NakagamiDistribution(double mu, double omega, double inverseAbsoluteAccuracy) {
        if (mu < 0.5) {
            throw new NumberIsTooSmallException(mu, (Number)0.5, true);
        }
        if (omega <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NOT_POSITIVE_SCALE, omega);
        }
        this.mu = mu;
        this.omega = omega;
        this.inverseAbsoluteAccuracy = inverseAbsoluteAccuracy;
    }

    public double getShape() {
        return this.mu;
    }

    public double getScale() {
        return this.omega;
    }

    @Override
    protected double getSolverAbsoluteAccuracy() {
        return this.inverseAbsoluteAccuracy;
    }

    @Override
    public double density(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return 2.0 * FastMath.pow(this.mu, this.mu) / (Gamma.value(this.mu) * FastMath.pow(this.omega, this.mu)) * FastMath.pow(x, 2.0 * this.mu - 1.0) * FastMath.exp(-this.mu * x * x / this.omega);
    }

    @Override
    public double cumulativeProbability(double x) {
        return RegularizedGamma.P.value(this.mu, this.mu * x * x / this.omega);
    }

    @Override
    public double getNumericalMean() {
        return Gamma.value(this.mu + 0.5) / Gamma.value(this.mu) * FastMath.sqrt(this.omega / this.mu);
    }

    @Override
    public double getNumericalVariance() {
        double v = Gamma.value(this.mu + 0.5) / Gamma.value(this.mu);
        return this.omega * (1.0 - 1.0 / this.mu * v * v);
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

