/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.distribution;

import org.apache.commons.math4.distribution.AbstractRealDistribution;
import org.apache.commons.math4.distribution.RealDistribution;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.NumberIsTooLargeException;
import org.apache.commons.math4.exception.OutOfRangeException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.numbers.gamma.ErfDifference;
import org.apache.commons.numbers.gamma.Erfc;
import org.apache.commons.numbers.gamma.InverseErf;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.GaussianSampler;
import org.apache.commons.rng.sampling.distribution.MarsagliaNormalizedGaussianSampler;

public class NormalDistribution
extends AbstractRealDistribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 8589540077390120676L;
    private static final double SQRT2 = FastMath.sqrt(2.0);
    private final double mean;
    private final double standardDeviation;
    private final double logStandardDeviationPlusHalfLog2Pi;
    private final double solverAbsoluteAccuracy;

    public NormalDistribution() {
        this(0.0, 1.0);
    }

    public NormalDistribution(double mean, double sd) throws NotStrictlyPositiveException {
        this(mean, sd, 1.0E-9);
    }

    public NormalDistribution(double mean, double sd, double inverseCumAccuracy) throws NotStrictlyPositiveException {
        if (sd <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.STANDARD_DEVIATION, sd);
        }
        this.mean = mean;
        this.standardDeviation = sd;
        this.logStandardDeviationPlusHalfLog2Pi = FastMath.log(sd) + 0.5 * FastMath.log(Math.PI * 2);
        this.solverAbsoluteAccuracy = inverseCumAccuracy;
    }

    public double getMean() {
        return this.mean;
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    @Override
    public double density(double x) {
        return FastMath.exp(this.logDensity(x));
    }

    @Override
    public double logDensity(double x) {
        double x0 = x - this.mean;
        double x1 = x0 / this.standardDeviation;
        return -0.5 * x1 * x1 - this.logStandardDeviationPlusHalfLog2Pi;
    }

    @Override
    public double cumulativeProbability(double x) {
        double dev = x - this.mean;
        if (FastMath.abs(dev) > 40.0 * this.standardDeviation) {
            return dev < 0.0 ? 0.0 : 1.0;
        }
        return 0.5 * Erfc.value(-dev / (this.standardDeviation * SQRT2));
    }

    @Override
    public double inverseCumulativeProbability(double p) throws OutOfRangeException {
        if (p < 0.0 || p > 1.0) {
            throw new OutOfRangeException(p, (Number)0, 1);
        }
        return this.mean + this.standardDeviation * SQRT2 * InverseErf.value(2.0 * p - 1.0);
    }

    @Override
    public double probability(double x0, double x1) throws NumberIsTooLargeException {
        if (x0 > x1) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_ENDPOINT_ABOVE_UPPER_ENDPOINT, (Number)x0, x1, true);
        }
        double denom = this.standardDeviation * SQRT2;
        double v0 = (x0 - this.mean) / denom;
        double v1 = (x1 - this.mean) / denom;
        return 0.5 * ErfDifference.value(v0, v1);
    }

    @Override
    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    @Override
    public double getNumericalMean() {
        return this.getMean();
    }

    @Override
    public double getNumericalVariance() {
        double s = this.getStandardDeviation();
        return s * s;
    }

    @Override
    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public RealDistribution.Sampler createSampler(final UniformRandomProvider rng) {
        return new RealDistribution.Sampler(){
            private final ContinuousSampler sampler;
            {
                this.sampler = new GaussianSampler(new MarsagliaNormalizedGaussianSampler(rng), NormalDistribution.this.mean, NormalDistribution.this.standardDeviation);
            }

            @Override
            public double sample() {
                return this.sampler.sample();
            }
        };
    }
}

