/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.distribution;

import org.apache.commons.math4.distribution.AbstractIntegerDistribution;
import org.apache.commons.math4.distribution.IntegerDistribution;
import org.apache.commons.math4.distribution.NormalDistribution;
import org.apache.commons.math4.distribution.SaddlePointExpansion;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.numbers.gamma.RegularizedGamma;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.sampling.distribution.PoissonSampler;

public class PoissonDistribution
extends AbstractIntegerDistribution {
    private static final int DEFAULT_MAX_ITERATIONS = 10000000;
    private static final double DEFAULT_EPSILON = 1.0E-12;
    private static final long serialVersionUID = -3349935121172596109L;
    private final NormalDistribution normal;
    private final double mean;
    private final int maxIterations;
    private final double epsilon;

    public PoissonDistribution(double p) throws NotStrictlyPositiveException {
        this(p, 1.0E-12, 10000000);
    }

    public PoissonDistribution(double p, double epsilon, int maxIterations) throws NotStrictlyPositiveException {
        if (p <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.MEAN, p);
        }
        this.mean = p;
        this.epsilon = epsilon;
        this.maxIterations = maxIterations;
        this.normal = new NormalDistribution(p, FastMath.sqrt(p), 1.0E-9);
    }

    public PoissonDistribution(double p, double epsilon) throws NotStrictlyPositiveException {
        this(p, epsilon, 10000000);
    }

    public PoissonDistribution(double p, int maxIterations) {
        this(p, 1.0E-12, maxIterations);
    }

    public double getMean() {
        return this.mean;
    }

    @Override
    public double probability(int x) {
        double logProbability = this.logProbability(x);
        return logProbability == Double.NEGATIVE_INFINITY ? 0.0 : FastMath.exp(logProbability);
    }

    @Override
    public double logProbability(int x) {
        double ret = x < 0 || x == Integer.MAX_VALUE ? Double.NEGATIVE_INFINITY : (x == 0 ? -this.mean : -SaddlePointExpansion.getStirlingError(x) - SaddlePointExpansion.getDeviancePart(x, this.mean) - 0.5 * FastMath.log(Math.PI * 2) - 0.5 * FastMath.log(x));
        return ret;
    }

    @Override
    public double cumulativeProbability(int x) {
        if (x < 0) {
            return 0.0;
        }
        if (x == Integer.MAX_VALUE) {
            return 1.0;
        }
        return RegularizedGamma.Q.value((double)x + 1.0, this.mean, this.epsilon, this.maxIterations);
    }

    public double normalApproximateProbability(int x) {
        return this.normal.cumulativeProbability((double)x + 0.5);
    }

    @Override
    public double getNumericalMean() {
        return this.getMean();
    }

    @Override
    public double getNumericalVariance() {
        return this.getMean();
    }

    @Override
    public int getSupportLowerBound() {
        return 0;
    }

    @Override
    public int getSupportUpperBound() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public IntegerDistribution.Sampler createSampler(final UniformRandomProvider rng) {
        return new IntegerDistribution.Sampler(){
            private final DiscreteSampler sampler;
            {
                this.sampler = new PoissonSampler(rng, PoissonDistribution.this.mean);
            }

            @Override
            public int sample() {
                return this.sampler.sample();
            }
        };
    }
}

