/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.geometry.euclidean.oned;

import java.text.NumberFormat;
import org.apache.commons.math4.exception.MathArithmeticException;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.geometry.Point;
import org.apache.commons.math4.geometry.Space;
import org.apache.commons.math4.geometry.Vector;
import org.apache.commons.math4.geometry.euclidean.oned.Euclidean1D;
import org.apache.commons.math4.geometry.euclidean.oned.Vector1D;
import org.apache.commons.math4.geometry.euclidean.oned.Vector1DFormat;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.math4.util.MathUtils;

public class Cartesian1D
extends Vector1D
implements Point<Euclidean1D> {
    public static final Cartesian1D ZERO = new Cartesian1D(0.0);
    public static final Cartesian1D ONE = new Cartesian1D(1.0);
    public static final Cartesian1D NaN = new Cartesian1D(Double.NaN);
    public static final Cartesian1D POSITIVE_INFINITY = new Cartesian1D(Double.POSITIVE_INFINITY);
    public static final Cartesian1D NEGATIVE_INFINITY = new Cartesian1D(Double.NEGATIVE_INFINITY);
    private static final long serialVersionUID = 7556674948671647925L;
    private final double x;

    public Cartesian1D(double x) {
        this.x = x;
    }

    public Cartesian1D(double a, Cartesian1D u) {
        this.x = a * u.x;
    }

    public Cartesian1D(double a1, Cartesian1D u1, double a2, Cartesian1D u2) {
        this.x = a1 * u1.x + a2 * u2.x;
    }

    public Cartesian1D(double a1, Cartesian1D u1, double a2, Cartesian1D u2, double a3, Cartesian1D u3) {
        this.x = a1 * u1.x + a2 * u2.x + a3 * u3.x;
    }

    public Cartesian1D(double a1, Cartesian1D u1, double a2, Cartesian1D u2, double a3, Cartesian1D u3, double a4, Cartesian1D u4) {
        this.x = a1 * u1.x + a2 * u2.x + a3 * u3.x + a4 * u4.x;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public Space getSpace() {
        return Euclidean1D.getInstance();
    }

    public Cartesian1D getZero() {
        return ZERO;
    }

    @Override
    public double getNorm1() {
        return FastMath.abs(this.x);
    }

    @Override
    public double getNorm() {
        return FastMath.abs(this.x);
    }

    @Override
    public double getNormSq() {
        return this.x * this.x;
    }

    @Override
    public double getNormInf() {
        return FastMath.abs(this.x);
    }

    public Cartesian1D add(Vector<Euclidean1D> v) {
        Cartesian1D v1 = (Cartesian1D)v;
        return new Cartesian1D(this.x + v1.getX());
    }

    public Cartesian1D add(double factor, Vector<Euclidean1D> v) {
        Cartesian1D v1 = (Cartesian1D)v;
        return new Cartesian1D(this.x + factor * v1.getX());
    }

    public Cartesian1D subtract(Vector<Euclidean1D> p) {
        Cartesian1D p3 = (Cartesian1D)p;
        return new Cartesian1D(this.x - p3.x);
    }

    public Cartesian1D subtract(double factor, Vector<Euclidean1D> v) {
        Cartesian1D v1 = (Cartesian1D)v;
        return new Cartesian1D(this.x - factor * v1.getX());
    }

    public Cartesian1D normalize() throws MathArithmeticException {
        double s = this.getNorm();
        if (s == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.CANNOT_NORMALIZE_A_ZERO_NORM_VECTOR, new Object[0]);
        }
        return this.scalarMultiply(1.0 / s);
    }

    public Cartesian1D negate() {
        return new Cartesian1D(-this.x);
    }

    public Cartesian1D scalarMultiply(double a) {
        return new Cartesian1D(a * this.x);
    }

    @Override
    public boolean isNaN() {
        return Double.isNaN(this.x);
    }

    @Override
    public boolean isInfinite() {
        return !this.isNaN() && Double.isInfinite(this.x);
    }

    @Override
    public double distance1(Vector<Euclidean1D> p) {
        Cartesian1D p1 = (Cartesian1D)p;
        double dx = FastMath.abs(p1.x - this.x);
        return dx;
    }

    @Override
    public double distance(Point<Euclidean1D> p) {
        return this.distance((Cartesian1D)p);
    }

    @Override
    public double distance(Vector<Euclidean1D> v) {
        return this.distance((Cartesian1D)v);
    }

    public double distance(Cartesian1D c) {
        double dx = c.x - this.x;
        return FastMath.abs(dx);
    }

    @Override
    public double distanceInf(Vector<Euclidean1D> p) {
        Cartesian1D p1 = (Cartesian1D)p;
        double dx = FastMath.abs(p1.x - this.x);
        return dx;
    }

    @Override
    public double distanceSq(Vector<Euclidean1D> p) {
        Cartesian1D p1 = (Cartesian1D)p;
        double dx = p1.x - this.x;
        return dx * dx;
    }

    @Override
    public double dotProduct(Vector<Euclidean1D> v) {
        Cartesian1D v1 = (Cartesian1D)v;
        return this.x * v1.x;
    }

    public static double distance(Cartesian1D p1, Cartesian1D p2) {
        return p1.distance(p2);
    }

    public static double distanceInf(Cartesian1D p1, Cartesian1D p2) {
        return p1.distanceInf(p2);
    }

    public static double distanceSq(Cartesian1D p1, Cartesian1D p2) {
        return p1.distanceSq(p2);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Cartesian1D) {
            Cartesian1D rhs = (Cartesian1D)other;
            if (rhs.isNaN()) {
                return this.isNaN();
            }
            return this.x == rhs.x;
        }
        return false;
    }

    public int hashCode() {
        if (this.isNaN()) {
            return 7785;
        }
        return 997 * MathUtils.hash(this.x);
    }

    public String toString() {
        return Vector1DFormat.getInstance().format(this);
    }

    @Override
    public String toString(NumberFormat format) {
        return new Vector1DFormat(format).format(this);
    }
}

