/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.geometry.euclidean.threed;

import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.geometry.Point;
import org.apache.commons.math4.geometry.Vector;
import org.apache.commons.math4.geometry.euclidean.oned.Cartesian1D;
import org.apache.commons.math4.geometry.euclidean.oned.Euclidean1D;
import org.apache.commons.math4.geometry.euclidean.oned.IntervalsSet;
import org.apache.commons.math4.geometry.euclidean.threed.Cartesian3D;
import org.apache.commons.math4.geometry.euclidean.threed.Euclidean3D;
import org.apache.commons.math4.geometry.euclidean.threed.SubLine;
import org.apache.commons.math4.geometry.partitioning.Embedding;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.numbers.core.Precision;

public class Line
implements Embedding<Euclidean3D, Euclidean1D> {
    private Cartesian3D direction;
    private Cartesian3D zero;
    private final double tolerance;

    public Line(Cartesian3D p1, Cartesian3D p2, double tolerance) throws MathIllegalArgumentException {
        this.reset(p1, p2);
        this.tolerance = tolerance;
    }

    public Line(Line line) {
        this.direction = line.direction;
        this.zero = line.zero;
        this.tolerance = line.tolerance;
    }

    public void reset(Cartesian3D p1, Cartesian3D p2) throws MathIllegalArgumentException {
        Vector delta = p2.subtract((Vector)p1);
        double norm2 = ((Cartesian3D)delta).getNormSq();
        if (norm2 == 0.0) {
            throw new MathIllegalArgumentException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        this.direction = new Cartesian3D(1.0 / FastMath.sqrt(norm2), (Cartesian3D)delta);
        this.zero = new Cartesian3D(1.0, p1, -p1.dotProduct(delta) / norm2, (Cartesian3D)delta);
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public Line revert() {
        Line reverted = new Line(this);
        reverted.direction = reverted.direction.negate();
        return reverted;
    }

    public Cartesian3D getDirection() {
        return this.direction;
    }

    public Cartesian3D getOrigin() {
        return this.zero;
    }

    public double getAbscissa(Cartesian3D point) {
        return ((Cartesian3D)point.subtract((Vector)this.zero)).dotProduct(this.direction);
    }

    public Cartesian3D pointAt(double abscissa) {
        return new Cartesian3D(1.0, this.zero, abscissa, this.direction);
    }

    public Cartesian1D toSubSpace(Vector<Euclidean3D> vector) {
        return this.toSubSpace((Point)((Object)vector));
    }

    public Cartesian3D toSpace(Vector<Euclidean1D> vector) {
        return this.toSpace((Point)((Object)vector));
    }

    public Cartesian1D toSubSpace(Point<Euclidean3D> point) {
        return this.toSubSpace((Cartesian3D)point);
    }

    public Cartesian3D toSpace(Point<Euclidean1D> point) {
        return this.toSpace((Cartesian1D)point);
    }

    public Cartesian1D toSubSpace(Cartesian3D point) {
        return new Cartesian1D(this.getAbscissa(point));
    }

    public Cartesian3D toSpace(Cartesian1D point) {
        return this.pointAt(point.getX());
    }

    public boolean isSimilarTo(Line line) {
        double angle = Cartesian3D.angle(this.direction, line.direction);
        return (angle < this.tolerance || angle > Math.PI - this.tolerance) && this.contains(line.zero);
    }

    public boolean contains(Cartesian3D p) {
        return this.distance(p) < this.tolerance;
    }

    public double distance(Cartesian3D p) {
        Vector d = p.subtract((Vector)this.zero);
        Cartesian3D n = new Cartesian3D(1.0, (Cartesian3D)d, -((Cartesian3D)d).dotProduct(this.direction), this.direction);
        return n.getNorm();
    }

    public double distance(Line line) {
        Cartesian3D normal = Cartesian3D.crossProduct(this.direction, line.direction);
        double n = normal.getNorm();
        if (n < Precision.SAFE_MIN) {
            return this.distance(line.zero);
        }
        double offset = ((Cartesian3D)line.zero.subtract((Vector)this.zero)).dotProduct(normal) / n;
        return FastMath.abs(offset);
    }

    public Cartesian3D closestPoint(Line line) {
        double cos = this.direction.dotProduct(line.direction);
        double n = 1.0 - cos * cos;
        if (n < Precision.EPSILON) {
            return this.zero;
        }
        Vector delta0 = line.zero.subtract((Vector)this.zero);
        double a = ((Cartesian3D)delta0).dotProduct(this.direction);
        double b = ((Cartesian3D)delta0).dotProduct(line.direction);
        return new Cartesian3D(1.0, this.zero, (a - b * cos) / n, this.direction);
    }

    public Cartesian3D intersection(Line line) {
        Cartesian3D closest = this.closestPoint(line);
        return line.contains(closest) ? closest : null;
    }

    public SubLine wholeLine() {
        return new SubLine(this, new IntervalsSet(this.tolerance));
    }
}

