/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.util.MathArrays;
import org.apache.commons.math4.util.PivotingStrategyInterface;
import org.apache.commons.rng.RestorableUniformRandomProvider;
import org.apache.commons.rng.core.RandomProviderDefaultState;
import org.apache.commons.rng.simple.RandomSource;

public class RandomPivotingStrategy
implements PivotingStrategyInterface,
Serializable {
    private static final long serialVersionUID = 20160517L;
    private final RandomSource randomSource;
    private transient RestorableUniformRandomProvider random;

    public RandomPivotingStrategy(RandomSource randomSource, long seed) {
        this.randomSource = randomSource;
        this.random = RandomSource.create(randomSource, seed, new Object[0]);
    }

    @Override
    public int pivotIndex(double[] work, int begin, int end) throws MathIllegalArgumentException {
        MathArrays.verifyValues(work, begin, end - begin);
        return begin + this.random.nextInt(end - begin - 1);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(((RandomProviderDefaultState)this.random.saveState()).getState());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.random = RandomSource.create(this.randomSource);
        RandomProviderDefaultState state = new RandomProviderDefaultState((byte[])in.readObject());
        this.random.restoreState(state);
    }
}

