/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.MarsagliaNormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.SamplerBase;

public class MarsagliaLogNormalSampler
extends SamplerBase
implements ContinuousSampler {
    private final double scale;
    private final double shape;
    private final NormalizedGaussianSampler gaussian;

    public MarsagliaLogNormalSampler(UniformRandomProvider rng, double scale, double shape) {
        super(null);
        this.scale = scale;
        this.shape = shape;
        this.gaussian = new MarsagliaNormalizedGaussianSampler(rng);
    }

    @Override
    public double sample() {
        return Math.exp(this.scale + this.shape * this.gaussian.sample());
    }

    @Override
    public String toString() {
        return "Marsaglia Log Normal [" + this.gaussian.toString() + "]";
    }
}

