/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.SamplerBase;

public class ZigguratNormalizedGaussianSampler
extends SamplerBase
implements NormalizedGaussianSampler {
    private static final int[] KN;
    private static final double[] WN;
    private static final double[] FN;

    public ZigguratNormalizedGaussianSampler(UniformRandomProvider rng) {
        super(rng);
    }

    @Override
    public double sample() {
        int i;
        int j = this.nextInt();
        return j < KN[i = j & 0x7F] ? (double)j * WN[i] : this.nfix(j, i);
    }

    private double nfix(int hz, int iz) {
        double r = 3.442619855899;
        do {
            double uni = 0.5 + (double)hz * 2.328306E-10;
            double x = (double)hz * WN[iz];
            if (iz == 0) {
                double y;
                do {
                    y = -Math.log(uni);
                    x = y * 0.2904764;
                    uni = 0.5 + (double)this.nextInt() * 2.328306E-10;
                } while (y + y < x * x);
                return hz > 0 ? 3.442619855899 + x : -3.442619855899 - x;
            }
            if (FN[iz] + uni * (FN[iz - 1] - FN[iz]) < Math.exp(-0.5 * x * x)) {
                return x;
            }
            hz = this.nextInt();
            iz = hz & 0x7F;
        } while (Math.abs(hz) >= KN[iz]);
        return (double)hz * WN[iz];
    }

    @Override
    public String toString() {
        return "Ziggurat normalized Gaussian deviate [" + super.toString() + "]";
    }

    static {
        double dn;
        KN = new int[128];
        WN = new double[128];
        FN = new double[128];
        double m = 2.147483648E9;
        double vn = 0.00991256303526217;
        double tn = dn = 3.442619855899;
        double e = Math.exp(-0.5 * dn * dn);
        double q = 0.00991256303526217 / e;
        ZigguratNormalizedGaussianSampler.KN[0] = (int)(dn / q * 2.147483648E9);
        ZigguratNormalizedGaussianSampler.KN[1] = 0;
        ZigguratNormalizedGaussianSampler.WN[0] = q / 2.147483648E9;
        ZigguratNormalizedGaussianSampler.WN[127] = dn / 2.147483648E9;
        ZigguratNormalizedGaussianSampler.FN[0] = 1.0;
        ZigguratNormalizedGaussianSampler.FN[127] = e;
        for (int i = 126; i >= 1; --i) {
            e = Math.exp(-0.5 * dn * dn);
            dn = Math.sqrt(-2.0 * Math.log(0.00991256303526217 / dn + e));
            ZigguratNormalizedGaussianSampler.KN[i + 1] = (int)(dn / tn * 2.147483648E9);
            tn = dn;
            ZigguratNormalizedGaussianSampler.FN[i] = e;
            ZigguratNormalizedGaussianSampler.WN[i] = dn / 2.147483648E9;
        }
    }
}

