/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.extensions.optimizers;

import com.codahale.metrics.MetricRegistry;
import io.engineblock.extensions.optimizers.MVLogger;
import io.engineblock.extensions.optimizers.MVParams;
import io.engineblock.extensions.optimizers.MVResult;
import io.engineblock.extensions.optimizers.MultivariateObjectScript;
import java.util.Arrays;
import java.util.List;
import javax.script.ScriptContext;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.optim.InitialGuess;
import org.apache.commons.math3.optim.MaxEval;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.SimpleBounds;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunction;
import org.apache.commons.math3.optim.nonlinear.scalar.noderiv.BOBYQAOptimizer;
import org.slf4j.Logger;

public class BobyqaOptimizerInstance {
    private final Logger logger;
    private final MetricRegistry metricRegistry;
    private final ScriptContext scriptContext;
    private int interpolations = 0;
    private double initialTrustRegionRadius = Double.MAX_VALUE;
    private double stoppingTrustRegionRadius = 1.0;
    private MVParams params = new MVParams();
    private MultivariateObjectScript objectiveScriptObject;
    private SimpleBounds bounds;
    private InitialGuess initialGuess;
    private PointValuePair result;
    private int maxEval;
    private MVLogger mvLogger;
    private double guessSlew = 0.25;

    public BobyqaOptimizerInstance(Logger logger, MetricRegistry metricRegistry, ScriptContext scriptContext) {
        this.logger = logger;
        this.metricRegistry = metricRegistry;
        this.scriptContext = scriptContext;
    }

    public BobyqaOptimizerInstance setPoints(int numberOfInterpolationPoints) {
        this.interpolations = numberOfInterpolationPoints;
        return this;
    }

    public BobyqaOptimizerInstance setInitialRadius(double initialTrustRegionRadius) {
        this.initialTrustRegionRadius = initialTrustRegionRadius;
        return this;
    }

    public BobyqaOptimizerInstance setStoppingRadius(double stoppingTrustRegionRadius) {
        this.stoppingTrustRegionRadius = stoppingTrustRegionRadius;
        return this;
    }

    public BobyqaOptimizerInstance setMaxPoints() {
        return this.setPoints(this.getMaxInterpolations());
    }

    public int getMaxInterpolations() {
        return (int)(0.5 * (double)((this.params.size() + 1) * (this.params.size() + 2)));
    }

    public BobyqaOptimizerInstance setMinPoints() {
        return this.setPoints(this.getMinInterpolations());
    }

    public int getMinInterpolations() {
        return this.params.size() + 2;
    }

    public BobyqaOptimizerInstance setBounds(double ... values) {
        double[] bottom = Arrays.copyOfRange(values, 0, values.length >> 1);
        double[] top = Arrays.copyOfRange(values, values.length >> 1, values.length);
        this.bounds = new SimpleBounds(bottom, top);
        return this;
    }

    public BobyqaOptimizerInstance setObjectiveFunction(Object f) {
        if (f instanceof ScriptObjectMirror) {
            ScriptObjectMirror scriptObject = (ScriptObjectMirror)f;
            if (!scriptObject.isFunction()) {
                throw new RuntimeException("Unable to setFunction with a non-function object");
            }
            this.objectiveScriptObject = new MultivariateObjectScript(this.logger, this.params, scriptObject);
        }
        return this;
    }

    public BobyqaOptimizerInstance setMaxEval(int maxEval) {
        this.maxEval = maxEval;
        return this;
    }

    public MVResult optimize() {
        this.initialGuess = this.initialGuess == null ? this.computeInitialGuess() : this.initialGuess;
        this.bounds = this.bounds == null ? this.computeBounds() : this.bounds;
        this.interpolations = this.interpolations == 0 ? this.getMinInterpolations() : this.interpolations;
        BOBYQAOptimizer mo = new BOBYQAOptimizer(this.interpolations, this.initialTrustRegionRadius, this.stoppingTrustRegionRadius);
        this.mvLogger = new MVLogger(this.objectiveScriptObject);
        ObjectiveFunction objective = new ObjectiveFunction((MultivariateFunction)this.mvLogger);
        List<SimpleBounds> od = List.of(objective, GoalType.MAXIMIZE, this.initialGuess, new MaxEval(this.maxEval), this.bounds);
        this.result = mo.optimize(od.toArray(new OptimizationData[0]));
        return new MVResult(this.result.getPoint(), this.params, this.mvLogger.getLogArray());
    }

    public BobyqaOptimizerInstance setGuessRatio(double slew) {
        this.guessSlew = slew;
        return this;
    }

    private SimpleBounds computeBounds() {
        double[] lb = new double[this.params.size()];
        double[] ub = new double[this.params.size()];
        int pos = 0;
        for (MVParams.MVParam param : this.params) {
            lb[pos] = param.min;
            ub[pos] = param.max;
            ++pos;
        }
        return new SimpleBounds(lb, ub);
    }

    private InitialGuess computeInitialGuess() {
        double[] guess = new double[this.params.size()];
        int pos = 0;
        for (MVParams.MVParam param : this.params) {
            guess[pos++] = param.min + (param.max - param.min) * this.guessSlew;
        }
        return new InitialGuess(guess);
    }

    public BobyqaOptimizerInstance param(String name, double min, double max) {
        this.params.addParam(name, min, max);
        return this;
    }

    public double[] getResult() {
        return this.result.getPoint();
    }
}

