/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.connection;

import io.fluxcapacitor.common.api.JsonType;
import io.fluxcapacitor.common.api.QueryResult;
import io.fluxcapacitor.common.api.Request;
import io.fluxcapacitor.javaclient.common.connection.SingleSessionSupplier;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebsocketService {
    private static final Logger log = LoggerFactory.getLogger(AbstractWebsocketService.class);
    private final Map<Long, CompletableFuture<QueryResult>> callbacks = new ConcurrentHashMap<Long, CompletableFuture<QueryResult>>();
    private final Supplier<Session> sessionSupplier;

    public AbstractWebsocketService(URI endpointUri) {
        this.sessionSupplier = new SingleSessionSupplier(endpointUri, this);
    }

    public AbstractWebsocketService(Supplier<Session> sessionSupplier) {
        this.sessionSupplier = sessionSupplier;
    }

    protected Session getSession() {
        return this.sessionSupplier.get();
    }

    protected <R extends QueryResult> R sendRequest(Request request) {
        CompletableFuture future = new CompletableFuture();
        this.callbacks.put(request.getRequestId(), future);
        try {
            this.getSession().getBasicRemote().sendObject((Object)request);
            return (R)((QueryResult)future.get());
        }
        catch (Exception e) {
            this.callbacks.remove(request.getRequestId());
            throw new IllegalStateException("Failed to handle request " + request, e);
        }
    }

    @OnMessage
    public void onMessage(JsonType value) {
        QueryResult readResult = (QueryResult)value;
        CompletableFuture<QueryResult> callback = this.callbacks.remove(readResult.getRequestId());
        if (callback == null) {
            log.warn("Could not find outstanding read request for id {}", (Object)readResult.getRequestId());
        } else {
            callback.complete(readResult);
        }
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        log.info("Connection to endpoint {} closed with reason {}", (Object)session.getRequestURI(), (Object)closeReason);
        this.getSession();
    }

    @OnError
    public void onError(Session session, Throwable e) {
        log.error("Client side error for web socket connected to endpoint {}", (Object)session.getRequestURI(), (Object)e);
    }
}

