/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.repository;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.fluxcapacitor.javaclient.common.repository.Repository;
import java.util.concurrent.ExecutionException;

public class CachingRepository<T>
implements Repository<T> {
    private final Repository<T> delegate;
    private final Cache<Object, T> cache;

    public CachingRepository(Repository<T> delegate) {
        this(delegate, CacheBuilder.newBuilder().maximumSize(100000L).build());
    }

    public CachingRepository(Repository<T> delegate, Cache<Object, T> cache) {
        this.delegate = delegate;
        this.cache = cache;
    }

    @Override
    public void put(Object id, T value) {
        this.cache.put(id, value);
        this.delegate.put(id, value);
    }

    @Override
    public T get(Object id) {
        try {
            return (T)this.cache.get(id, () -> this.delegate.get(id));
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Delegate repository threw an exception while loading " + id, e);
        }
    }

    @Override
    public void delete(Object id) {
        this.cache.invalidate(id);
        this.delegate.delete(id);
    }
}

