/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.repository;

import io.fluxcapacitor.javaclient.common.repository.Repository;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class InMemoryRepository<T>
implements Repository<T> {
    private final Map<Object, T> values;

    public InMemoryRepository() {
        this(new ConcurrentHashMap());
    }

    protected InMemoryRepository(Map<Object, T> map) {
        this.values = map;
    }

    @Override
    public void put(Object id, T value) {
        this.values.put(id, value);
    }

    @Override
    public T get(Object id) {
        return this.values.get(id);
    }

    @Override
    public void delete(Object id) {
        this.values.remove(id);
    }

    protected Map<Object, T> getValues() {
        return this.values;
    }

    public Stream<T> find(Predicate<? super T> predicate) {
        return this.values.values().stream().filter(predicate);
    }
}

