/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization;

import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.serialization.Revision;
import io.fluxcapacitor.javaclient.common.serialization.SerializationException;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.common.serialization.upcasting.Upcaster;
import java.util.stream.Stream;

public abstract class AbstractSerializer
implements Serializer {
    private final Upcaster<Data<byte[]>> upcasterChain;

    protected AbstractSerializer(Upcaster<Data<byte[]>> upcasterChain) {
        this.upcasterChain = upcasterChain;
    }

    @Override
    public Data<byte[]> serialize(Object object) {
        byte[] bytes;
        try {
            bytes = this.doSerialize(object);
        }
        catch (Exception e) {
            throw new SerializationException("Could not serialize " + object, e);
        }
        Revision revision = object.getClass().getAnnotation(Revision.class);
        return new Data((Object)bytes, object.getClass().getName(), revision == null ? 0 : revision.value());
    }

    protected abstract byte[] doSerialize(Object var1) throws Exception;

    @Override
    public Stream<Object> deserialize(Stream<Data<byte[]>> dataStream) {
        return this.upcasterChain.upcast(dataStream).map(data -> {
            try {
                return this.doDeserialize((byte[])data.getValue(), Class.forName(data.getType()));
            }
            catch (Exception e) {
                throw new SerializationException("Could not deserialize a " + data.getType(), e);
            }
        });
    }

    protected abstract <T> T doDeserialize(byte[] var1, Class<? extends T> var2) throws Exception;
}

