/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.javaclient.common.serialization.AbstractSerializer;
import io.fluxcapacitor.javaclient.common.serialization.jackson.ObjectNodeConverter;
import io.fluxcapacitor.javaclient.common.serialization.upcasting.Upcaster;
import io.fluxcapacitor.javaclient.common.serialization.upcasting.UpcasterChain;
import java.util.Collection;
import java.util.Collections;

public class JacksonSerializer
extends AbstractSerializer {
    public static final ObjectMapper defaultObjectMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private final ObjectMapper objectMapper;

    public JacksonSerializer() {
        this(Collections.emptyList());
    }

    public JacksonSerializer(Collection<?> upcasters) {
        this(defaultObjectMapper, upcasters);
    }

    public JacksonSerializer(ObjectMapper objectMapper, Collection<?> upcasters) {
        this(objectMapper, UpcasterChain.create(upcasters, new ObjectNodeConverter(objectMapper)));
    }

    public JacksonSerializer(ObjectMapper objectMapper, Upcaster<Data<byte[]>> upcasterChain) {
        super(upcasterChain);
        this.objectMapper = objectMapper;
    }

    @Override
    protected byte[] doSerialize(Object object) throws Exception {
        return this.objectMapper.writeValueAsBytes(object);
    }

    @Override
    protected <T> T doDeserialize(byte[] bytes, Class<? extends T> type) throws Exception {
        return (T)this.objectMapper.readValue(bytes, type);
    }
}

