/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.fluxcapacitor.javaclient.common.serialization.SerializationException;
import io.fluxcapacitor.javaclient.common.serialization.upcasting.Converter;
import java.beans.ConstructorProperties;
import java.io.IOException;

public class ObjectNodeConverter
implements Converter<ObjectNode> {
    private final ObjectMapper objectMapper;

    @Override
    public ObjectNode convert(byte[] bytes) {
        try {
            return (ObjectNode)this.objectMapper.readTree(bytes);
        }
        catch (IOException e) {
            throw new SerializationException("Could not read JsonNode from byte[]", e);
        }
    }

    @Override
    public byte[] convert(ObjectNode value) {
        try {
            return this.objectMapper.writeValueAsBytes((Object)value);
        }
        catch (JsonProcessingException e) {
            throw new SerializationException("Could not write byte[] from JsonNode: " + value, e);
        }
    }

    @Override
    public Class<ObjectNode> getDataType() {
        return ObjectNode.class;
    }

    @ConstructorProperties(value={"objectMapper"})
    public ObjectNodeConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

