/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization.upcasting;

import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.javaclient.common.serialization.upcasting.AnnotatedUpcaster;
import io.fluxcapacitor.javaclient.common.serialization.upcasting.Upcast;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public class UpcastInspector {
    private static final Comparator<AnnotatedUpcaster<?>> upcasterComparator = Comparator.comparing(u -> u.getAnnotation().revision()).thenComparing(u -> u.getAnnotation().type());

    public static <T> List<AnnotatedUpcaster<T>> inspect(Collection<?> upcasters, Class<T> dataType) {
        ArrayList<AnnotatedUpcaster<T>> result = new ArrayList<AnnotatedUpcaster<T>>();
        for (Object upcaster : upcasters) {
            for (Method method : upcaster.getClass().getMethods()) {
                if (!method.isAnnotationPresent(Upcast.class)) continue;
                result.add(UpcastInspector.createUpcaster(method, upcaster, dataType));
            }
        }
        result.sort(upcasterComparator);
        return result;
    }

    private static <T> AnnotatedUpcaster<T> createUpcaster(Method method, Object target, Class<T> dataType) {
        if (method.getReturnType().equals(Void.TYPE)) {
            return new AnnotatedUpcaster(method, i -> Stream.empty());
        }
        Function invokeFunction = UpcastInspector.invokeFunction(method, target, dataType);
        Function resultMapper = UpcastInspector.mapResult(method, dataType);
        return new AnnotatedUpcaster(method, d -> (Stream)resultMapper.apply(invokeFunction.apply((Data)d)));
    }

    private static <T> Function<Data<T>, Object> invokeFunction(Method method, Object target, Class<T> dataType) {
        Type[] parameters = method.getGenericParameterTypes();
        if (parameters.length != 1) {
            throw new IllegalArgumentException(String.format("Upcaster method '%s' has unexpected number of parameters. Expected 1 or 0.", method));
        }
        if (parameters[0] instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)parameters[0];
            if (parameterizedType.getRawType().equals(Data.class) && dataType.isAssignableFrom((Class)parameterizedType.getActualTypeArguments()[0])) {
                return data -> UpcastInspector.invokeMethod(method, data, target);
            }
            if (dataType.isAssignableFrom((Class)parameterizedType.getRawType())) {
                return data -> UpcastInspector.invokeMethod(method, data.getValue(), target);
            }
        } else if (dataType.isAssignableFrom((Class)parameters[0])) {
            return data -> UpcastInspector.invokeMethod(method, data.getValue(), target);
        }
        throw new IllegalArgumentException(String.format("First parameter in upcaster method '%s' is of unexpected type. Expected Data<%s> or %s.", method, dataType.getName(), dataType.getName()));
    }

    private static Object invokeMethod(Method method, Object argument, Object target) {
        try {
            return method.invoke(target, argument);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Not allowed to invoke method: " + method, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Exception while upcasting using method: " + method, e);
        }
    }

    private static <T> Function<Object, Stream<Data<T>>> mapResult(Method method, Class<T> dataType) {
        if (dataType.isAssignableFrom(method.getReturnType())) {
            Upcast annotation = method.getAnnotation(Upcast.class);
            return r -> Stream.of(new Data(r, annotation.type(), annotation.revision() + 1));
        }
        if (method.getReturnType().equals(Data.class)) {
            return r -> Stream.of((Data)r);
        }
        if (method.getReturnType().equals(Optional.class)) {
            ParameterizedType parameterizedType = (ParameterizedType)method.getGenericReturnType();
            if (parameterizedType.getActualTypeArguments()[0] instanceof Class) {
                Class typeParameter = (Class)parameterizedType.getActualTypeArguments()[0];
                if (dataType.isAssignableFrom(typeParameter)) {
                    Upcast annotation = method.getAnnotation(Upcast.class);
                    return r -> ((Optional)r).map(d -> Stream.of(new Data(d, annotation.type(), annotation.revision() + 1))).orElse(Stream.empty());
                }
            } else if (parameterizedType.getActualTypeArguments()[0] instanceof ParameterizedType && ((ParameterizedType)parameterizedType.getActualTypeArguments()[0]).getRawType().equals(Data.class)) {
                return r -> ((Optional)r).map(Stream::of).orElse(Stream.empty());
            }
        }
        if (method.getReturnType().equals(Stream.class)) {
            return r -> (Stream)r;
        }
        throw new IllegalStateException(String.format("Unexpected return type of upcaster method '%s'. Expected Data<%s>, %s, Optional<Data<%s>>, Optional<%s>, Stream<Data<%s>> or void", method, dataType.getName(), dataType.getName(), dataType.getName(), dataType.getName(), dataType.getName()));
    }
}

