/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.eventsourcing;

import io.fluxcapacitor.common.api.Message;
import io.fluxcapacitor.javaclient.common.repository.Repository;
import io.fluxcapacitor.javaclient.common.serialization.SerializationException;
import io.fluxcapacitor.javaclient.eventsourcing.EventStore;
import io.fluxcapacitor.javaclient.eventsourcing.Snapshot;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSourcingRepository<T>
implements Repository<T> {
    private static final Logger log = LoggerFactory.getLogger(EventSourcingRepository.class);
    private final EventStore eventStore;
    private final BiFunction<T, Message, T> eventHandler;

    public EventSourcingRepository(EventStore eventStore, BiFunction<T, Message, T> eventHandler) {
        this.eventStore = eventStore;
        this.eventHandler = eventHandler;
    }

    @Override
    public T get(Object id) {
        String aggregateId = id.toString();
        Optional<Snapshot> snapshot = this.eventStore.getSnapshot(aggregateId);
        Object value = null;
        try {
            value = snapshot.map(s -> this.eventHandler.apply(null, new Message(s.getData()))).orElse(null);
        }
        catch (SerializationException e) {
            log.warn("Failed to load snapshot for aggregate {}. Deleting existing one.", id, (Object)e);
            snapshot = Optional.empty();
            this.eventStore.deleteSnapshot(aggregateId);
        }
        Iterator messageIterator = snapshot.map(s -> this.eventStore.getEvents(aggregateId, s.getLastSequenceNumber())).orElse(this.eventStore.getEvents(aggregateId)).iterator();
        while (messageIterator.hasNext()) {
            value = this.eventHandler.apply(value, (Message)messageIterator.next());
        }
        return value;
    }

    @Override
    public void delete(Object id) {
    }

    @Override
    public void put(Object id, T value) {
    }
}

