/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.eventsourcing;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.api.Message;
import io.fluxcapacitor.common.api.eventsourcing.EventBatch;
import io.fluxcapacitor.javaclient.eventsourcing.EventStore;
import io.fluxcapacitor.javaclient.eventsourcing.Snapshot;
import io.fluxcapacitor.javaclient.tracking.InMemoryMessageStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class InMemoryEventStore
extends InMemoryMessageStore
implements EventStore {
    private final Map<String, List<EventBatch>> domainEvents = new ConcurrentHashMap<String, List<EventBatch>>();
    private final Map<String, Snapshot> snapshots = new ConcurrentHashMap<String, Snapshot>();

    @Override
    public Awaitable storeEvents(String aggregateId, String domain, long lastSequenceNumber, List<Message> events) {
        this.domainEvents.compute(aggregateId, (id, list) -> {
            if (list == null) {
                list = new ArrayList<EventBatch>();
            }
            list.add(new EventBatch(aggregateId, domain, lastSequenceNumber, events));
            return list;
        });
        return super.send(events.toArray(new Message[0]));
    }

    @Override
    public Stream<Message> getEvents(String aggregateId, long lastSequenceNumber) {
        return this.domainEvents.getOrDefault(aggregateId, Collections.emptyList()).stream().filter(batch -> batch.getLastSequenceNumber() > lastSequenceNumber).flatMap(batch -> {
            List events = batch.getEvents();
            if (batch.getFirstSequenceNumber() > lastSequenceNumber) {
                return events.stream();
            }
            return events.stream().skip(lastSequenceNumber - batch.getFirstSequenceNumber() + 1L);
        });
    }

    @Override
    public void storeSnapshot(Snapshot snapshot) {
        this.snapshots.put(snapshot.getAggregateId(), snapshot);
    }

    @Override
    public Optional<Snapshot> getSnapshot(String aggregateId) {
        return Optional.ofNullable(this.snapshots.get(aggregateId));
    }

    @Override
    public void deleteSnapshot(String aggregateId) {
        this.snapshots.remove(aggregateId);
    }

    @Override
    public Awaitable send(Message ... messages) {
        throw new UnsupportedOperationException("Use #storeEvents instead");
    }
}

