/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.eventsourcing.websocket;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.Backlog;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.api.Message;
import io.fluxcapacitor.common.api.Request;
import io.fluxcapacitor.common.api.eventsourcing.AppendEvents;
import io.fluxcapacitor.common.api.eventsourcing.EventBatch;
import io.fluxcapacitor.common.api.eventsourcing.GetEvents;
import io.fluxcapacitor.common.api.eventsourcing.GetEventsResult;
import io.fluxcapacitor.common.serialization.websocket.JsonDecoder;
import io.fluxcapacitor.common.serialization.websocket.JsonEncoder;
import io.fluxcapacitor.javaclient.common.connection.AbstractWebsocketService;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.common.serialization.jackson.JacksonSerializer;
import io.fluxcapacitor.javaclient.eventsourcing.EventStore;
import io.fluxcapacitor.javaclient.eventsourcing.Snapshot;
import io.fluxcapacitor.javaclient.keyvalue.KeyValueRepository;
import io.fluxcapacitor.javaclient.keyvalue.KeyValueService;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.websocket.ClientEndpoint;
import javax.websocket.EncodeException;

@ClientEndpoint(encoders={JsonEncoder.class}, decoders={JsonDecoder.class})
public class WebSocketEventStore
extends AbstractWebsocketService
implements EventStore {
    private final KeyValueRepository<Snapshot> snapshotRepository;
    private final Backlog<EventBatch> backlog;
    private final int fetchBatchSize;

    public WebSocketEventStore(String endPointUrl, KeyValueService keyValueService) {
        this(URI.create(endPointUrl), 1024, 1024, keyValueService, new JacksonSerializer());
    }

    public WebSocketEventStore(String endPointUrl, int backlogSize, KeyValueService keyValueService) {
        this(URI.create(endPointUrl), backlogSize, 1024, keyValueService, new JacksonSerializer());
    }

    public WebSocketEventStore(URI endPointUri, int backlogSize, int fetchBatchSize, KeyValueService keyValueService, Serializer serializer) {
        super(endPointUri);
        this.backlog = new Backlog(this::doSend, backlogSize);
        this.fetchBatchSize = fetchBatchSize;
        this.snapshotRepository = new KeyValueRepository(keyValueService, serializer);
    }

    @Override
    public Awaitable storeEvents(String aggregateId, String domain, long lastSequenceNumber, List<Message> events) {
        return this.backlog.add((Object[])new EventBatch[]{new EventBatch(aggregateId, domain, lastSequenceNumber, events)});
    }

    private Awaitable doSend(List<EventBatch> batches) throws IOException, EncodeException {
        this.getSession().getBasicRemote().sendObject((Object)new AppendEvents(batches));
        return Awaitable.ready();
    }

    @Override
    public Stream<Message> getEvents(String aggregateId, long lastSequenceNumber) {
        return ObjectUtils.iterate((Object)((GetEventsResult)this.sendRequest((Request)new GetEvents(aggregateId, Long.valueOf(lastSequenceNumber), this.fetchBatchSize))), r -> (GetEventsResult)this.sendRequest((Request)new GetEvents(aggregateId, Long.valueOf(r.getEventBatch().getLastSequenceNumber()), this.fetchBatchSize)), r -> r.getEventBatch().getEvents().size() < this.fetchBatchSize).flatMap(r -> r.getEventBatch().getEvents().stream());
    }

    @Override
    public void storeSnapshot(Snapshot snapshot) {
        this.snapshotRepository.put(snapshot.getAggregateId(), snapshot);
    }

    @Override
    public Optional<Snapshot> getSnapshot(String aggregateId) {
        return Optional.ofNullable(this.snapshotRepository.get(aggregateId));
    }

    @Override
    public void deleteSnapshot(String aggregateId) {
        this.snapshotRepository.delete(aggregateId);
    }
}

