/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.keyvalue;

import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.javaclient.common.repository.Repository;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.keyvalue.KeyValueService;

public class KeyValueRepository<T>
implements Repository<T> {
    private final KeyValueService keyValueService;
    private final Serializer serializer;

    public KeyValueRepository(KeyValueService keyValueService, Serializer serializer) {
        this.keyValueService = keyValueService;
        this.serializer = serializer;
    }

    @Override
    public void put(Object id, T value) {
        try {
            this.keyValueService.putValue(id.toString(), this.serializer.serialize(value)).await();
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Could not store a value %s for key %s", value, id), e);
        }
    }

    @Override
    public T get(Object id) {
        Data<byte[]> result = this.keyValueService.getValue(id.toString());
        return result == null ? null : (T)this.serializer.deserialize(result);
    }

    @Override
    public void delete(Object id) {
        this.keyValueService.deleteValue(id.toString());
    }
}

