/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.javaclient.common.model.Model;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.eventsourcing.EventSourced;
import io.fluxcapacitor.javaclient.eventsourcing.EventSourcing;
import io.fluxcapacitor.javaclient.keyvalue.KeyValueStore;
import io.fluxcapacitor.javaclient.publishing.CommandGateway;
import io.fluxcapacitor.javaclient.publishing.ErrorGateway;
import io.fluxcapacitor.javaclient.publishing.EventGateway;
import io.fluxcapacitor.javaclient.publishing.MetricsGateway;
import io.fluxcapacitor.javaclient.publishing.QueryGateway;
import io.fluxcapacitor.javaclient.publishing.ResultGateway;
import io.fluxcapacitor.javaclient.scheduling.Scheduler;
import io.fluxcapacitor.javaclient.tracking.Tracking;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

public interface FluxCapacitor {
    public static final ThreadLocal<FluxCapacitor> instance = new ThreadLocal();

    public static FluxCapacitor get() {
        return Optional.ofNullable(instance.get()).orElseThrow(() -> new IllegalStateException("FluxCapacitor instance not set"));
    }

    public static void publishEvent(Object event) {
        FluxCapacitor.get().eventGateway().publish(event);
    }

    public static void publishEvent(Object payload, Metadata metadata) {
        FluxCapacitor.get().eventGateway().publish(payload, metadata);
    }

    public static void sendAndForgetCommand(Object command) {
        FluxCapacitor.get().commandGateway().sendAndForget(command, Metadata.empty());
    }

    public static void sendAndForgetCommand(Object payload, Metadata metadata) {
        FluxCapacitor.get().commandGateway().sendAndForget(payload, metadata);
    }

    public static <R> CompletableFuture<R> sendCommand(Object command) {
        return FluxCapacitor.get().commandGateway().send(command, Metadata.empty());
    }

    public static <R> CompletableFuture<R> sendCommand(Object payload, Metadata metadata) {
        return FluxCapacitor.get().commandGateway().send(payload, metadata);
    }

    public static <R> CompletableFuture<R> query(Object query) {
        return FluxCapacitor.get().queryGateway().send(query);
    }

    public static <R> CompletableFuture<R> query(Object payload, Metadata metadata) {
        return FluxCapacitor.get().queryGateway().send(payload, metadata);
    }

    public static void publishMetrics(Object metrics) {
        FluxCapacitor.get().metricsGateway().publish(metrics);
    }

    public static void publishMetrics(Object payload, Metadata metadata) {
        FluxCapacitor.get().metricsGateway().publish(payload, metadata);
    }

    public static <T> Model<T> loadAggregate(String id, Class<T> modelType) {
        if (modelType.isAnnotationPresent(EventSourced.class)) {
            return FluxCapacitor.get().eventSourcing().load(id, modelType);
        }
        throw new UnsupportedOperationException("Only event sourced aggregates are supported at the moment");
    }

    public static String getProperty(String key) {
        return FluxCapacitor.get().properties().getProperty(key, System.getProperty(key));
    }

    public static String getProperty(String key, String defaultValue) {
        return FluxCapacitor.get().properties().getProperty(key, System.getProperty(key, defaultValue));
    }

    default public Registration startTracking(Object ... handlers) {
        return this.startTracking(Arrays.asList(handlers));
    }

    default public Registration startTracking(List<?> handlers) {
        return Arrays.stream(MessageType.values()).map(t -> this.tracking((MessageType)t).start(this, handlers)).reduce(Registration::merge).orElse(Registration.noOp());
    }

    default public Registration registerLocalHandlers(Object ... handlers) {
        return this.registerLocalHandlers(Arrays.asList(handlers));
    }

    default public Registration registerLocalHandlers(List<?> handlers) {
        return handlers.stream().flatMap(h -> Stream.of(this.commandGateway().registerLocalHandler(h), this.queryGateway().registerLocalHandler(h), this.eventGateway().registerLocalHandler(h), this.eventSourcing().eventStore().registerLocalHandler(h))).reduce(Registration::merge).orElse(Registration.noOp());
    }

    public EventSourcing eventSourcing();

    public Scheduler scheduler();

    public KeyValueStore keyValueStore();

    public CommandGateway commandGateway();

    public QueryGateway queryGateway();

    public EventGateway eventGateway();

    public ResultGateway resultGateway();

    public ErrorGateway errorGateway();

    public MetricsGateway metricsGateway();

    public Tracking tracking(MessageType var1);

    public Client client();

    public Properties properties();
}

