/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.javaclient.common.IdentityProvider;
import io.fluxcapacitor.javaclient.common.UuidFactory;
import java.beans.ConstructorProperties;

public final class Message {
    public static IdentityProvider identityProvider = new UuidFactory();
    private final Object payload;
    private final Metadata metadata;
    private final MessageType messageType;
    private final String messageId;

    public Message(Object payload, MessageType messageType) {
        this(payload, Metadata.empty(), messageType, identityProvider.nextId());
    }

    public Message(Object payload, Metadata metadata, MessageType messageType) {
        this(payload, metadata, messageType, identityProvider.nextId());
    }

    public <R> R getPayload() {
        return (R)this.payload;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        Object this$payload = this.getPayload();
        Object other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) {
            return false;
        }
        Metadata this$metadata = this.getMetadata();
        Metadata other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
            return false;
        }
        MessageType this$messageType = this.getMessageType();
        MessageType other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !this$messageType.equals(other$messageType)) {
            return false;
        }
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        return !(this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        Metadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        MessageType $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : $messageType.hashCode());
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        return result;
    }

    public String toString() {
        return "Message(payload=" + this.getPayload() + ", metadata=" + this.getMetadata() + ", messageType=" + this.getMessageType() + ", messageId=" + this.getMessageId() + ")";
    }

    @ConstructorProperties(value={"payload", "metadata", "messageType", "messageId"})
    public Message(Object payload, Metadata metadata, MessageType messageType, String messageId) {
        this.payload = payload;
        this.metadata = metadata;
        this.messageType = messageType;
        this.messageId = messageId;
    }

    public Message withPayload(Object payload) {
        return this.payload == payload ? this : new Message(payload, this.metadata, this.messageType, this.messageId);
    }
}

